/*
 * Decompiled with CFR 0.152.
 */
package io.arconia.opentelemetry.autoconfigure.traces;

import io.arconia.opentelemetry.autoconfigure.traces.ConditionalOnOpenTelemetryTracing;
import io.arconia.opentelemetry.autoconfigure.traces.OpenTelemetryTracerProviderBuilderCustomizer;
import io.arconia.opentelemetry.autoconfigure.traces.OpenTelemetryTracingProperties;
import io.micrometer.tracing.exporter.SpanExportingPredicate;
import io.micrometer.tracing.exporter.SpanFilter;
import io.micrometer.tracing.exporter.SpanReporter;
import io.micrometer.tracing.otel.bridge.CompositeSpanExporter;
import io.micrometer.tracing.otel.bridge.OtelTracer;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SdkTracerProviderBuilder;
import io.opentelemetry.sdk.trace.SpanLimits;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessorBuilder;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.SpringBootVersion;
import org.springframework.boot.actuate.autoconfigure.tracing.TracingProperties;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(before={org.springframework.boot.actuate.autoconfigure.tracing.OpenTelemetryTracingAutoConfiguration.class})
@ConditionalOnClass(value={SdkTracerProvider.class})
@ConditionalOnOpenTelemetryTracing
@EnableConfigurationProperties(value={OpenTelemetryTracingProperties.class})
public final class OpenTelemetryTracingAutoConfiguration {
    public static final String INSTRUMENTATION_SCOPE_NAME = "org.springframework.boot";

    @Bean
    @ConditionalOnMissingBean
    SdkTracerProvider tracerProvider(Clock clock, Resource resource, Sampler sampler, SpanLimits spanLimits, ObjectProvider<SpanProcessor> spanProcessors, ObjectProvider<OpenTelemetryTracerProviderBuilderCustomizer> customizers) {
        SdkTracerProviderBuilder builder = SdkTracerProvider.builder().setResource(resource).setSampler(sampler).setClock(clock).setSpanLimits(spanLimits);
        spanProcessors.orderedStream().forEach(arg_0 -> ((SdkTracerProviderBuilder)builder).addSpanProcessor(arg_0));
        customizers.orderedStream().forEach(customizer -> customizer.customize(builder));
        return builder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    Sampler sampler(OpenTelemetryTracingProperties properties, TracingProperties tracingProperties) {
        return switch (properties.getSampling().getStrategy()) {
            default -> throw new MatchException(null, null);
            case OpenTelemetryTracingProperties.SamplingStrategy.ALWAYS_ON -> Sampler.alwaysOn();
            case OpenTelemetryTracingProperties.SamplingStrategy.ALWAYS_OFF -> Sampler.alwaysOff();
            case OpenTelemetryTracingProperties.SamplingStrategy.TRACE_ID_RATIO -> Sampler.traceIdRatioBased((double)tracingProperties.getSampling().getProbability());
            case OpenTelemetryTracingProperties.SamplingStrategy.PARENT_BASED_ALWAYS_ON -> Sampler.parentBased((Sampler)Sampler.alwaysOn());
            case OpenTelemetryTracingProperties.SamplingStrategy.PARENT_BASED_ALWAYS_OFF -> Sampler.parentBased((Sampler)Sampler.alwaysOff());
            case OpenTelemetryTracingProperties.SamplingStrategy.PARENT_BASED_TRACE_ID_RATIO -> Sampler.parentBased((Sampler)Sampler.traceIdRatioBased((double)tracingProperties.getSampling().getProbability()));
        };
    }

    @Bean
    @ConditionalOnMissingBean
    SpanLimits spanLimits(OpenTelemetryTracingProperties properties) {
        return SpanLimits.builder().setMaxAttributeValueLength(properties.getLimits().getMaxAttributeValueLength()).setMaxNumberOfAttributes(properties.getLimits().getMaxNumberOfAttributes()).setMaxNumberOfEvents(properties.getLimits().getMaxNumberOfEvents()).setMaxNumberOfLinks(properties.getLimits().getMaxNumberOfLinks()).setMaxNumberOfAttributesPerEvent(properties.getLimits().getMaxNumberOfAttributesPerEvent()).setMaxNumberOfAttributesPerLink(properties.getLimits().getMaxNumberOfAttributesPerLink()).build();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(value={OtelTracer.class})
    BatchSpanProcessor micrometerBatchSpanProcessor(OpenTelemetryTracingProperties properties, ObjectProvider<SpanExporter> spanExporters, ObjectProvider<SpanExportingPredicate> spanExportingPredicates, ObjectProvider<SpanReporter> spanReporters, ObjectProvider<SpanFilter> spanFilters, ObjectProvider<MeterProvider> meterProvider) {
        CompositeSpanExporter spanExporter = new CompositeSpanExporter(spanExporters.orderedStream().toList(), spanExportingPredicates.orderedStream().toList(), spanReporters.orderedStream().toList(), spanFilters.orderedStream().toList());
        BatchSpanProcessorBuilder spanProcessorBuilder = BatchSpanProcessor.builder((SpanExporter)spanExporter).setExportUnsampledSpans(properties.getProcessor().isExportUnsampledSpans()).setExporterTimeout(properties.getProcessor().getExportTimeout()).setScheduleDelay(properties.getProcessor().getScheduleDelay()).setMaxExportBatchSize(properties.getProcessor().getMaxExportBatchSize()).setMaxQueueSize(properties.getProcessor().getMaxQueueSize());
        if (properties.getProcessor().isMetrics()) {
            meterProvider.ifAvailable(arg_0 -> ((BatchSpanProcessorBuilder)spanProcessorBuilder).setMeterProvider(arg_0));
        }
        return spanProcessorBuilder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    ContextPropagators contextPropagators(ObjectProvider<TextMapPropagator> textMapPropagators) {
        return ContextPropagators.create((TextMapPropagator)TextMapPropagator.composite(textMapPropagators.orderedStream().toList()));
    }

    @Bean
    @ConditionalOnMissingBean
    Tracer otelTracer(OpenTelemetry openTelemetry) {
        return openTelemetry.getTracer(INSTRUMENTATION_SCOPE_NAME, SpringBootVersion.getVersion());
    }
}

