/*
 * Decompiled with CFR 0.152.
 */
package io.arconia.opentelemetry.autoconfigure.resource.contributor;

import io.arconia.core.support.Incubating;
import io.arconia.opentelemetry.autoconfigure.resource.contributor.ResourceContributor;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.sdk.resources.ResourceBuilder;
import org.springframework.boot.info.JavaInfo;
import org.springframework.util.StringUtils;

@Incubating(since="0.5.0")
public final class JavaResourceContributor
implements ResourceContributor {
    public static final AttributeKey<String> PROCESS_RUNTIME_DESCRIPTION = AttributeKey.stringKey((String)"process.runtime.description");
    public static final AttributeKey<String> PROCESS_RUNTIME_NAME = AttributeKey.stringKey((String)"process.runtime.name");
    public static final AttributeKey<String> PROCESS_RUNTIME_VERSION = AttributeKey.stringKey((String)"process.runtime.version");
    private final JavaInfo javaInfo = new JavaInfo();

    @Override
    public void contribute(ResourceBuilder builder) {
        if (StringUtils.hasText((String)this.javaInfo.getRuntime().getName())) {
            builder.put(PROCESS_RUNTIME_NAME, (Object)this.javaInfo.getRuntime().getName());
        }
        if (StringUtils.hasText((String)this.javaInfo.getRuntime().getVersion())) {
            builder.put(PROCESS_RUNTIME_VERSION, (Object)this.javaInfo.getRuntime().getVersion());
        }
        if (StringUtils.hasText((String)this.javaInfo.getJvm().getVendor()) && StringUtils.hasText((String)this.javaInfo.getJvm().getName()) && StringUtils.hasText((String)this.javaInfo.getJvm().getVersion())) {
            builder.put(PROCESS_RUNTIME_DESCRIPTION, (Object)"%s %s %s".formatted(this.javaInfo.getJvm().getVendor(), this.javaInfo.getJvm().getName(), this.javaInfo.getJvm().getVersion()));
        }
    }
}

