/*
 * Decompiled with CFR 0.152.
 */
package io.arconia.opentelemetry.autoconfigure.resource;

import io.arconia.opentelemetry.autoconfigure.ConditionalOnOpenTelemetry;
import io.arconia.opentelemetry.autoconfigure.resource.ConditionalOnOpenTelemetryResourceContributor;
import io.arconia.opentelemetry.autoconfigure.resource.OpenTelemetryResourceBuilderCustomizer;
import io.arconia.opentelemetry.autoconfigure.resource.OpenTelemetryResourceProperties;
import io.arconia.opentelemetry.autoconfigure.resource.contributor.BuildResourceContributor;
import io.arconia.opentelemetry.autoconfigure.resource.contributor.EnvironmentResourceContributor;
import io.arconia.opentelemetry.autoconfigure.resource.contributor.HostResourceContributor;
import io.arconia.opentelemetry.autoconfigure.resource.contributor.JavaResourceContributor;
import io.arconia.opentelemetry.autoconfigure.resource.contributor.OsResourceContributor;
import io.arconia.opentelemetry.autoconfigure.resource.contributor.ProcessResourceContributor;
import io.arconia.opentelemetry.autoconfigure.resource.contributor.ResourceContributor;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.resources.ResourceBuilder;
import java.util.Map;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.opentelemetry.OpenTelemetryAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.info.BuildProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;

@AutoConfiguration(before={OpenTelemetryAutoConfiguration.class})
@ConditionalOnOpenTelemetry
@ConditionalOnClass(value={Resource.class})
@EnableConfigurationProperties(value={OpenTelemetryResourceProperties.class})
public final class OpenTelemetryResourceAutoConfiguration {
    public static final int DEFAULT_ORDER = -2147483638;

    @Bean
    @ConditionalOnMissingBean
    Resource resource(ObjectProvider<ResourceContributor> resourceContributors, ObjectProvider<OpenTelemetryResourceBuilderCustomizer> customizers) {
        ResourceBuilder builder = Resource.getDefault().toBuilder();
        resourceContributors.orderedStream().forEach(contributor -> contributor.contribute(builder));
        customizers.orderedStream().forEach(customizer -> customizer.customize(builder));
        return builder.build();
    }

    @Bean
    @ConditionalOnOpenTelemetryResourceContributor(value="build", matchIfMissing=true)
    @ConditionalOnBean(value={BuildProperties.class})
    @Order(value=-2147483638)
    BuildResourceContributor buildResourceContributor(BuildProperties properties) {
        return new BuildResourceContributor(properties);
    }

    @Bean
    @ConditionalOnOpenTelemetryResourceContributor(value="environment", matchIfMissing=true)
    @Order(value=-2147483648)
    EnvironmentResourceContributor environmentResourceContributor(Environment environment, OpenTelemetryResourceProperties properties) {
        return new EnvironmentResourceContributor(environment, properties);
    }

    @Bean
    @ConditionalOnOpenTelemetryResourceContributor(value="host")
    @Order(value=-2147483638)
    HostResourceContributor hostResourceContributor() {
        return new HostResourceContributor();
    }

    @Bean
    @ConditionalOnOpenTelemetryResourceContributor(value="java")
    @Order(value=-2147483638)
    JavaResourceContributor javaRuntimeResourceContributor() {
        return new JavaResourceContributor();
    }

    @Bean
    @ConditionalOnOpenTelemetryResourceContributor(value="os")
    @Order(value=-2147483638)
    OsResourceContributor osResourceContributor() {
        return new OsResourceContributor();
    }

    @Bean
    @ConditionalOnOpenTelemetryResourceContributor(value="process")
    @Order(value=-2147483638)
    ProcessResourceContributor processRuntimeResourceContributor() {
        return new ProcessResourceContributor();
    }

    @Bean
    OpenTelemetryResourceBuilderCustomizer filterAttributes(OpenTelemetryResourceProperties properties) {
        return builder -> {
            Map<String, Boolean> attributeKeysMap = properties.getEnable();
            Boolean allKeys = attributeKeysMap.get("all");
            if (allKeys == null) {
                attributeKeysMap.forEach((key, enabled) -> {
                    if (!enabled.booleanValue()) {
                        builder.removeIf(attributeKey -> attributeKey.getKey().startsWith((String)key));
                    }
                });
                return;
            }
            if (!allKeys.booleanValue()) {
                builder.removeIf(attributeKey -> true);
            }
        };
    }
}

