/*
 * Decompiled with CFR 0.152.
 */
package io.arconia.opentelemetry.autoconfigure.resource;

import io.arconia.opentelemetry.autoconfigure.resource.ConditionalOnOpenTelemetryResourceContributor;
import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.StringUtils;

class OnOpenTelemetryResourceContributorCondition
extends SpringBootCondition {
    private static final String CONTRIBUTOR_PROPERTY = "arconia.otel.resource.contributors.%s.enabled";

    OnOpenTelemetryResourceContributorCondition() {
    }

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        boolean matchIfMissing;
        Map attributes = metadata.getAnnotationAttributes(ConditionalOnOpenTelemetryResourceContributor.class.getName());
        String contributorName = attributes != null ? (String)attributes.get("value") : null;
        boolean bl = matchIfMissing = attributes != null && (Boolean)attributes.get("matchIfMissing") != false;
        if (StringUtils.hasLength((String)contributorName)) {
            Boolean contributorEnabled = (Boolean)context.getEnvironment().getProperty(CONTRIBUTOR_PROPERTY.formatted(contributorName), Boolean.class);
            if (contributorEnabled != null) {
                return new ConditionOutcome(contributorEnabled.booleanValue(), ConditionMessage.forCondition(ConditionalOnOpenTelemetryResourceContributor.class, (Object[])new Object[0]).because(CONTRIBUTOR_PROPERTY.formatted(contributorName) + " is " + contributorEnabled));
            }
            if (matchIfMissing) {
                return ConditionOutcome.match((ConditionMessage)ConditionMessage.forCondition(ConditionalOnOpenTelemetryResourceContributor.class, (Object[])new Object[0]).because("resource contributor is enabled by default"));
            }
            return ConditionOutcome.noMatch((ConditionMessage)ConditionMessage.forCondition(ConditionalOnOpenTelemetryResourceContributor.class, (Object[])new Object[0]).because("resource contributor is disabled by default"));
        }
        return ConditionOutcome.noMatch((ConditionMessage)ConditionMessage.forCondition(ConditionalOnOpenTelemetryResourceContributor.class, (Object[])new Object[0]).because("resource contributor is disabled by default"));
    }
}

