/*
 * Decompiled with CFR 0.152.
 */
package io.arconia.opentelemetry.autoconfigure.metrics.exporter;

import io.arconia.opentelemetry.autoconfigure.metrics.ConditionalOnOpenTelemetryMetrics;
import io.arconia.opentelemetry.autoconfigure.metrics.OpenTelemetryMeterProviderBuilderCustomizer;
import io.arconia.opentelemetry.autoconfigure.metrics.exporter.OpenTelemetryMetricsExporterProperties;
import io.arconia.opentelemetry.autoconfigure.metrics.exporter.console.ConsoleMetricsExporterConfiguration;
import io.arconia.opentelemetry.autoconfigure.metrics.exporter.otlp.OtlpMetricsExporterConfiguration;
import io.micrometer.core.instrument.util.NamedThreadFactory;
import io.opentelemetry.sdk.metrics.export.CardinalityLimitSelector;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import io.opentelemetry.sdk.metrics.export.MetricReader;
import io.opentelemetry.sdk.metrics.export.PeriodicMetricReader;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.metrics.export.otlp.OtlpMetricsExportAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnThreading;
import org.springframework.boot.autoconfigure.thread.Threading;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.core.task.VirtualThreadTaskExecutor;

@AutoConfiguration(before={OtlpMetricsExportAutoConfiguration.class})
@ConditionalOnOpenTelemetryMetrics
@Import(value={ConsoleMetricsExporterConfiguration.class, OtlpMetricsExporterConfiguration.class})
@EnableConfigurationProperties(value={OpenTelemetryMetricsExporterProperties.class})
public final class OpenTelemetryMetricsExporterAutoConfiguration {
    private static final String THREAD_NAME_PREFIX = "otel-metrics";

    @Bean
    @ConditionalOnThreading(value=Threading.PLATFORM)
    OpenTelemetryMeterProviderBuilderCustomizer metricBuilderPlatformThreads(OpenTelemetryMetricsExporterProperties properties, CardinalityLimitSelector cardinalityLimitSelector, ObjectProvider<MetricExporter> metricExporters) {
        NamedThreadFactory threadFactory = new NamedThreadFactory(THREAD_NAME_PREFIX);
        return builder -> metricExporters.orderedStream().forEach(metricExporter -> builder.registerMetricReader((MetricReader)PeriodicMetricReader.builder((MetricExporter)metricExporter).setInterval(properties.getInterval()).setExecutor(Executors.newSingleThreadScheduledExecutor((ThreadFactory)threadFactory)).build(), cardinalityLimitSelector));
    }

    @Bean
    @ConditionalOnThreading(value=Threading.VIRTUAL)
    OpenTelemetryMeterProviderBuilderCustomizer metricBuilderVirtualThreads(OpenTelemetryMetricsExporterProperties properties, CardinalityLimitSelector cardinalityLimitSelector, ObjectProvider<MetricExporter> metricExporters) {
        VirtualThreadTaskExecutor taskExecutor = new VirtualThreadTaskExecutor("otel-metrics-");
        return builder -> metricExporters.orderedStream().forEach(metricExporter -> builder.registerMetricReader((MetricReader)PeriodicMetricReader.builder((MetricExporter)metricExporter).setInterval(properties.getInterval()).setExecutor(Executors.newSingleThreadScheduledExecutor(taskExecutor.getVirtualThreadFactory())).build(), cardinalityLimitSelector));
    }
}

