/*
 * Decompiled with CFR 0.152.
 */
package io.arconia.opentelemetry.autoconfigure.metrics.exporter;

import io.arconia.opentelemetry.autoconfigure.exporter.ExporterType;
import io.arconia.opentelemetry.autoconfigure.metrics.exporter.ConditionalOnOpenTelemetryMetricsExporter;
import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.StringUtils;

class OnOpenTelemetryMetricsExporterCondition
extends SpringBootCondition {
    private static final String GENERAL_EXPORTER_TYPE = "arconia.otel.exporter.type";
    private static final String METRICS_EXPORTER_TYPE = "arconia.otel.metrics.exporter.type";

    OnOpenTelemetryMetricsExporterCondition() {
    }

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        ExporterType metricsExporterType;
        String requestedExporterType;
        Map attributes = metadata.getAnnotationAttributes(ConditionalOnOpenTelemetryMetricsExporter.class.getName());
        String string = requestedExporterType = attributes != null ? (String)attributes.get("value") : null;
        if (!StringUtils.hasText((String)requestedExporterType)) {
            return ConditionOutcome.noMatch((ConditionMessage)ConditionMessage.forCondition(ConditionalOnOpenTelemetryMetricsExporter.class, (Object[])new Object[0]).because("a valid exporter type is not specified"));
        }
        String generalExporterTypeString = context.getEnvironment().getProperty(GENERAL_EXPORTER_TYPE, "otlp");
        ExporterType generalExporterType = StringUtils.hasText((String)generalExporterTypeString) ? ExporterType.valueOf(generalExporterTypeString.toUpperCase()) : null;
        String metricsExporterTypeString = (String)context.getEnvironment().getProperty(METRICS_EXPORTER_TYPE, String.class);
        ExporterType exporterType = metricsExporterType = StringUtils.hasText((String)metricsExporterTypeString) ? ExporterType.valueOf(metricsExporterTypeString.toUpperCase()) : null;
        if (metricsExporterType != null) {
            if (metricsExporterType.toString().equalsIgnoreCase(requestedExporterType)) {
                return ConditionOutcome.match((ConditionMessage)ConditionMessage.forCondition(ConditionalOnOpenTelemetryMetricsExporter.class, (Object[])new Object[0]).because("arconia.otel.metrics.exporter.type is set to " + String.valueOf((Object)metricsExporterType)));
            }
            return ConditionOutcome.noMatch((ConditionMessage)ConditionMessage.forCondition(ConditionalOnOpenTelemetryMetricsExporter.class, (Object[])new Object[0]).because("arconia.otel.metrics.exporter.type is set to " + String.valueOf((Object)metricsExporterType) + ", but requested " + requestedExporterType));
        }
        if (generalExporterType != null) {
            if (generalExporterType.toString().equalsIgnoreCase(requestedExporterType)) {
                return ConditionOutcome.match((ConditionMessage)ConditionMessage.forCondition(ConditionalOnOpenTelemetryMetricsExporter.class, (Object[])new Object[0]).because("arconia.otel.exporter.type is set to " + String.valueOf((Object)generalExporterType)));
            }
            return ConditionOutcome.noMatch((ConditionMessage)ConditionMessage.forCondition(ConditionalOnOpenTelemetryMetricsExporter.class, (Object[])new Object[0]).because("arconia.otel.exporter.type is set to " + String.valueOf((Object)generalExporterType) + ", but requested " + requestedExporterType));
        }
        return ConditionOutcome.noMatch((ConditionMessage)ConditionMessage.forCondition(ConditionalOnOpenTelemetryMetricsExporter.class, (Object[])new Object[0]).because("exporter type not enabled: " + requestedExporterType));
    }
}

