/*
 * Decompiled with CFR 0.152.
 */
package io.arconia.opentelemetry.autoconfigure.logs.exporter.otlp;

import io.arconia.opentelemetry.autoconfigure.exporter.OpenTelemetryExporterProperties;
import io.arconia.opentelemetry.autoconfigure.exporter.otlp.Protocol;
import io.arconia.opentelemetry.autoconfigure.logs.exporter.ConditionalOnOpenTelemetryLoggingExporter;
import io.arconia.opentelemetry.autoconfigure.logs.exporter.OpenTelemetryLoggingExporterProperties;
import io.arconia.opentelemetry.autoconfigure.logs.exporter.otlp.OtlpLoggingConnectionDetails;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.exporter.otlp.http.logs.OtlpHttpLogRecordExporter;
import io.opentelemetry.exporter.otlp.http.logs.OtlpHttpLogRecordExporterBuilder;
import io.opentelemetry.exporter.otlp.logs.OtlpGrpcLogRecordExporter;
import io.opentelemetry.exporter.otlp.logs.OtlpGrpcLogRecordExporterBuilder;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.Assert;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={OtlpHttpLogRecordExporter.class})
@ConditionalOnOpenTelemetryLoggingExporter(value="otlp")
public final class OtlpLoggingExporterConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(OtlpLoggingExporterConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    OtlpLoggingConnectionDetails otlpLoggingConnectionDetails(OpenTelemetryExporterProperties commonProperties, OpenTelemetryLoggingExporterProperties properties) {
        return new PropertiesOtlpLoggingConnectionDetails(commonProperties, properties);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={OtlpLoggingConnectionDetails.class})
    @ConditionalOnProperty(prefix="arconia.otel.logs.exporter.otlp", name={"protocol"}, havingValue="http_protobuf", matchIfMissing=true)
    OtlpHttpLogRecordExporter otlpHttpLogRecordExporter(OpenTelemetryExporterProperties commonProperties, OpenTelemetryLoggingExporterProperties properties, OtlpLoggingConnectionDetails connectionDetails, ObjectProvider<MeterProvider> meterProvider) {
        OtlpHttpLogRecordExporterBuilder builder;
        block3: {
            block2: {
                builder = OtlpHttpLogRecordExporter.builder().setEndpoint(connectionDetails.getUrl(Protocol.HTTP_PROTOBUF)).setTimeout(properties.getOtlp().getTimeout() != null ? properties.getOtlp().getTimeout() : commonProperties.getOtlp().getTimeout()).setConnectTimeout(properties.getOtlp().getConnectTimeout() != null ? properties.getOtlp().getConnectTimeout() : commonProperties.getOtlp().getConnectTimeout()).setCompression(properties.getOtlp().getCompression() != null ? properties.getOtlp().getCompression().name().toLowerCase(Locale.ROOT) : commonProperties.getOtlp().getCompression().name().toLowerCase(Locale.ROOT)).setMemoryMode(commonProperties.getMemoryMode());
                commonProperties.getOtlp().getHeaders().forEach((arg_0, arg_1) -> ((OtlpHttpLogRecordExporterBuilder)builder).addHeader(arg_0, arg_1));
                properties.getOtlp().getHeaders().forEach((arg_0, arg_1) -> ((OtlpHttpLogRecordExporterBuilder)builder).addHeader(arg_0, arg_1));
                if (properties.getOtlp().isMetrics() != null && Boolean.TRUE.equals(properties.getOtlp().isMetrics())) break block2;
                if (properties.getOtlp().isMetrics() != null || !commonProperties.getOtlp().isMetrics()) break block3;
            }
            meterProvider.ifAvailable(arg_0 -> ((OtlpHttpLogRecordExporterBuilder)builder).setMeterProvider(arg_0));
        }
        logger.info("Configuring OpenTelemetry HTTP/Protobuf log exporter with endpoint: {}", (Object)connectionDetails.getUrl(Protocol.HTTP_PROTOBUF));
        return builder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={OtlpLoggingConnectionDetails.class})
    @ConditionalOnProperty(prefix="arconia.otel.logs.exporter.otlp", name={"protocol"}, havingValue="grpc")
    OtlpGrpcLogRecordExporter otlpGrpcLogRecordExporter(OpenTelemetryExporterProperties commonProperties, OpenTelemetryLoggingExporterProperties properties, OtlpLoggingConnectionDetails connectionDetails, ObjectProvider<MeterProvider> meterProvider) {
        OtlpGrpcLogRecordExporterBuilder builder;
        block3: {
            block2: {
                builder = OtlpGrpcLogRecordExporter.builder().setEndpoint(connectionDetails.getUrl(Protocol.GRPC)).setTimeout(properties.getOtlp().getTimeout() != null ? properties.getOtlp().getTimeout() : commonProperties.getOtlp().getTimeout()).setConnectTimeout(properties.getOtlp().getConnectTimeout() != null ? properties.getOtlp().getConnectTimeout() : commonProperties.getOtlp().getConnectTimeout()).setCompression(properties.getOtlp().getCompression() != null ? properties.getOtlp().getCompression().name().toLowerCase(Locale.ROOT) : commonProperties.getOtlp().getCompression().name().toLowerCase(Locale.ROOT)).setMemoryMode(commonProperties.getMemoryMode());
                commonProperties.getOtlp().getHeaders().forEach((arg_0, arg_1) -> ((OtlpGrpcLogRecordExporterBuilder)builder).addHeader(arg_0, arg_1));
                properties.getOtlp().getHeaders().forEach((arg_0, arg_1) -> ((OtlpGrpcLogRecordExporterBuilder)builder).addHeader(arg_0, arg_1));
                if (properties.getOtlp().isMetrics() != null && Boolean.TRUE.equals(properties.getOtlp().isMetrics())) break block2;
                if (properties.getOtlp().isMetrics() != null || !commonProperties.getOtlp().isMetrics()) break block3;
            }
            meterProvider.ifAvailable(arg_0 -> ((OtlpGrpcLogRecordExporterBuilder)builder).setMeterProvider(arg_0));
        }
        logger.info("Configuring OpenTelemetry gRPC log exporter with endpoint: {}", (Object)connectionDetails.getUrl(Protocol.GRPC));
        return builder.build();
    }

    static class PropertiesOtlpLoggingConnectionDetails
    implements OtlpLoggingConnectionDetails {
        private final OpenTelemetryExporterProperties commonProperties;
        private final OpenTelemetryLoggingExporterProperties properties;

        public PropertiesOtlpLoggingConnectionDetails(OpenTelemetryExporterProperties commonProperties, OpenTelemetryLoggingExporterProperties properties) {
            this.commonProperties = commonProperties;
            this.properties = properties;
        }

        @Override
        public String getUrl(Protocol protocol) {
            Protocol protocolProperty = this.properties.getOtlp().getProtocol() != null ? this.properties.getOtlp().getProtocol() : this.commonProperties.getOtlp().getProtocol();
            Assert.state((protocol == protocolProperty ? 1 : 0) != 0, (String)"Requested protocol %s doesn't match configured protocol %s".formatted(new Object[]{protocol, protocolProperty}));
            String url = this.properties.getOtlp().getEndpoint() != null ? this.properties.getOtlp().getEndpoint().toString() : (this.commonProperties.getOtlp().getEndpoint() != null ? (protocolProperty == Protocol.HTTP_PROTOBUF ? this.commonProperties.getOtlp().getEndpoint().resolve("/v1/logs").toString() : this.commonProperties.getOtlp().getEndpoint().toString()) : (protocolProperty == Protocol.HTTP_PROTOBUF ? "http://localhost:4318/v1/logs" : "http://localhost:4317"));
            return url;
        }
    }
}

