/*
 * Decompiled with CFR 0.152.
 */
package io.arconia.opentelemetry.autoconfigure.logs.exporter;

import io.arconia.opentelemetry.autoconfigure.exporter.ExporterType;
import io.arconia.opentelemetry.autoconfigure.logs.exporter.ConditionalOnOpenTelemetryLoggingExporter;
import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.StringUtils;

class OnOpenTelemetryLoggingExporterCondition
extends SpringBootCondition {
    private static final String GENERAL_EXPORTER_TYPE = "arconia.otel.exporter.type";
    private static final String LOGS_EXPORTER_TYPE = "arconia.otel.logs.exporter.type";

    OnOpenTelemetryLoggingExporterCondition() {
    }

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        ExporterType logsExporterType;
        String requestedExporterType;
        Map attributes = metadata.getAnnotationAttributes(ConditionalOnOpenTelemetryLoggingExporter.class.getName());
        String string = requestedExporterType = attributes != null ? (String)attributes.get("value") : null;
        if (!StringUtils.hasText((String)requestedExporterType)) {
            return ConditionOutcome.noMatch((ConditionMessage)ConditionMessage.forCondition(ConditionalOnOpenTelemetryLoggingExporter.class, (Object[])new Object[0]).because("a valid exporter type is not specified"));
        }
        String generalExporterTypeString = context.getEnvironment().getProperty(GENERAL_EXPORTER_TYPE, "otlp");
        ExporterType generalExporterType = StringUtils.hasText((String)generalExporterTypeString) ? ExporterType.valueOf(generalExporterTypeString.toUpperCase()) : null;
        String logsExporterTypeString = (String)context.getEnvironment().getProperty(LOGS_EXPORTER_TYPE, String.class);
        ExporterType exporterType = logsExporterType = StringUtils.hasText((String)logsExporterTypeString) ? ExporterType.valueOf(logsExporterTypeString.toUpperCase()) : null;
        if (logsExporterType != null) {
            if (logsExporterType.toString().equalsIgnoreCase(requestedExporterType)) {
                return ConditionOutcome.match((ConditionMessage)ConditionMessage.forCondition(ConditionalOnOpenTelemetryLoggingExporter.class, (Object[])new Object[0]).because("arconia.otel.logs.exporter.type is set to " + String.valueOf((Object)logsExporterType)));
            }
            return ConditionOutcome.noMatch((ConditionMessage)ConditionMessage.forCondition(ConditionalOnOpenTelemetryLoggingExporter.class, (Object[])new Object[0]).because("arconia.otel.logs.exporter.type is set to " + String.valueOf((Object)logsExporterType) + ", but requested " + requestedExporterType));
        }
        if (generalExporterType != null) {
            if (generalExporterType.toString().equalsIgnoreCase(requestedExporterType)) {
                return ConditionOutcome.match((ConditionMessage)ConditionMessage.forCondition(ConditionalOnOpenTelemetryLoggingExporter.class, (Object[])new Object[0]).because("arconia.otel.exporter.type is set to " + String.valueOf((Object)generalExporterType)));
            }
            return ConditionOutcome.noMatch((ConditionMessage)ConditionMessage.forCondition(ConditionalOnOpenTelemetryLoggingExporter.class, (Object[])new Object[0]).because("arconia.otel.exporter.type is set to " + String.valueOf((Object)generalExporterType) + ", but requested " + requestedExporterType));
        }
        return ConditionOutcome.noMatch((ConditionMessage)ConditionMessage.forCondition(ConditionalOnOpenTelemetryLoggingExporter.class, (Object[])new Object[0]).because("exporter type not enabled: " + requestedExporterType));
    }
}

