/*
 * Decompiled with CFR 0.152.
 */
package io.arconia.opentelemetry.autoconfigure.logs;

import java.time.Duration;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="arconia.otel.logs")
public class OpenTelemetryLoggingProperties {
    public static final String CONFIG_PREFIX = "arconia.otel.logs";
    private final LogLimits limits = new LogLimits();
    private final LogRecordProcessorConfig processor = new LogRecordProcessorConfig();

    public LogLimits getLimits() {
        return this.limits;
    }

    public LogRecordProcessorConfig getProcessor() {
        return this.processor;
    }

    public static class LogLimits {
        private int maxAttributeValueLength = Integer.MAX_VALUE;
        private int maxNumberOfAttributes = 128;

        public int getMaxAttributeValueLength() {
            return this.maxAttributeValueLength;
        }

        public void setMaxAttributeValueLength(int maxAttributeValueLength) {
            this.maxAttributeValueLength = maxAttributeValueLength;
        }

        public int getMaxNumberOfAttributes() {
            return this.maxNumberOfAttributes;
        }

        public void setMaxNumberOfAttributes(int maxNumberOfAttributes) {
            this.maxNumberOfAttributes = maxNumberOfAttributes;
        }
    }

    public static class LogRecordProcessorConfig {
        private Duration scheduleDelay = Duration.ofSeconds(1L);
        private Duration exportTimeout = Duration.ofSeconds(30L);
        private int maxQueueSize = 2048;
        private int maxExportBatchSize = 512;
        private boolean metrics = false;

        public Duration getScheduleDelay() {
            return this.scheduleDelay;
        }

        public void setScheduleDelay(Duration scheduleDelay) {
            this.scheduleDelay = scheduleDelay;
        }

        public Duration getExportTimeout() {
            return this.exportTimeout;
        }

        public void setExportTimeout(Duration exporterTimeout) {
            this.exportTimeout = exporterTimeout;
        }

        public int getMaxQueueSize() {
            return this.maxQueueSize;
        }

        public void setMaxQueueSize(int maxQueueSize) {
            this.maxQueueSize = maxQueueSize;
        }

        public int getMaxExportBatchSize() {
            return this.maxExportBatchSize;
        }

        public void setMaxExportBatchSize(int maxExportBatchSize) {
            this.maxExportBatchSize = maxExportBatchSize;
        }

        public boolean isMetrics() {
            return this.metrics;
        }

        public void setMetrics(boolean metrics) {
            this.metrics = metrics;
        }
    }
}

