/*
 * Decompiled with CFR 0.152.
 */
package io.arconia.opentelemetry.autoconfigure.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class SpringBootEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    private static final String PROPERTY_SOURCE_NAME = "arconia-opentelemetry-spring-boot";
    private static final String SPRING_AUTOCONFIGURE_EXCLUDE = "spring.autoconfigure.exclude";

    SpringBootEnvironmentPostProcessor() {
    }

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        Assert.notNull((Object)environment, (String)"environment cannot be null");
        HashMap<String, Object> arconiaProperties = new HashMap<String, Object>();
        SpringBootEnvironmentPostProcessor.setExcludedAutoConfigurations(SpringBootEnvironmentPostProcessor.getAutoConfigurations(environment), environment, arconiaProperties);
        MapPropertySource mapPropertySource = new MapPropertySource(PROPERTY_SOURCE_NAME, arconiaProperties);
        MutablePropertySources mutablePropertySources = environment.getPropertySources();
        mutablePropertySources.addFirst((PropertySource)mapPropertySource);
    }

    private static List<String> getAutoConfigurations(ConfigurableEnvironment environment) {
        ArrayList<String> autoConfigurations = new ArrayList<String>(List.of("org.springframework.boot.actuate.autoconfigure.opentelemetry.OpenTelemetryAutoConfiguration", "org.springframework.boot.actuate.autoconfigure.logging.OpenTelemetryLoggingAutoConfiguration", "org.springframework.boot.actuate.autoconfigure.logging.otlp.OtlpLoggingAutoConfiguration", "org.springframework.boot.actuate.autoconfigure.metrics.export.otlp.OtlpMetricsExportAutoConfiguration", "org.springframework.boot.actuate.autoconfigure.tracing.otlp.OtlpTracingAutoConfiguration"));
        if (!((Boolean)environment.getProperty("arconia.otel.enabled", Boolean.class, (Object)true)).booleanValue()) {
            autoConfigurations.add("org.springframework.boot.actuate.autoconfigure.tracing.OpenTelemetryTracingAutoConfiguration");
        }
        return autoConfigurations;
    }

    static void setExcludedAutoConfigurations(List<String> autoConfigurations, ConfigurableEnvironment environment, Map<String, Object> arconiaProperties) {
        String value = environment.getProperty(SPRING_AUTOCONFIGURE_EXCLUDE);
        String additionalValue = String.join((CharSequence)",", autoConfigurations);
        if (StringUtils.hasText((String)value)) {
            arconiaProperties.put(SPRING_AUTOCONFIGURE_EXCLUDE, value + "," + additionalValue);
        } else {
            arconiaProperties.put(SPRING_AUTOCONFIGURE_EXCLUDE, additionalValue);
        }
    }
}

