/*
 * Decompiled with CFR 0.152.
 */
package io.arconia.opentelemetry.autoconfigure.config;

import io.arconia.core.config.adapter.PropertyAdapter;
import io.arconia.opentelemetry.autoconfigure.config.OpenTelemetryEnvironmentPropertyConverters;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.util.Assert;

class OpenTelemetryEnvironmentPropertyAdapters {
    OpenTelemetryEnvironmentPropertyAdapters() {
    }

    static PropertyAdapter general(ConfigurableEnvironment environment) {
        Assert.notNull((Object)environment, (String)"environment cannot be null");
        return PropertyAdapter.builder((ConfigurableEnvironment)environment).mapProperty("otel.sdk.disabled", "arconia.otel.enabled", value -> !Boolean.parseBoolean(value.toLowerCase())).mapMap("otel.resource.attributes", "arconia.otel.resource.attributes").mapString("otel.service.name", "arconia.otel.resource.service-name").mapEnum("otel.propagators", "management.tracing.propagation.produce", OpenTelemetryEnvironmentPropertyConverters::propagationType).mapEnum("otel.tracer.sampler", "arconia.otel.traces.sampling.strategy", OpenTelemetryEnvironmentPropertyConverters::samplingStrategy).mapDouble("otel.tracer.sampler.arg", "management.tracing.sampling.probability").build();
    }

    static PropertyAdapter batchSpanProcessor(ConfigurableEnvironment environment) {
        Assert.notNull((Object)environment, (String)"environment cannot be null");
        return PropertyAdapter.builder((ConfigurableEnvironment)environment).mapDuration("otel.bsp.schedule.delay", "arconia.otel.traces.processor.schedule-delay").mapDuration("otel.bsp.export.timeout", "arconia.otel.traces.processor.exporter-timeout").mapInteger("otel.bsp.max.queue.size", "arconia.otel.traces.processor.max-queue-size").mapInteger("otel.bsp.max.export.batch.size", "arconia.otel.traces.processor.max-export-batch-size").build();
    }

    static PropertyAdapter logRecordProcessor(ConfigurableEnvironment environment) {
        Assert.notNull((Object)environment, (String)"environment cannot be null");
        return PropertyAdapter.builder((ConfigurableEnvironment)environment).mapDuration("otel.blrp.schedule.delay", "arconia.otel.logs.processor.schedule-delay").mapDuration("otel.blrp.export.timeout", "arconia.otel.logs.processor.exporter-timeout").mapInteger("otel.blrp.max.queue.size", "arconia.otel.logs.processor.max-queue-size").mapInteger("otel.blrp.max.export.batch.size", "arconia.otel.logs.processor.max-export-batch-size").build();
    }

    static PropertyAdapter attributeLimits(ConfigurableEnvironment environment) {
        Assert.notNull((Object)environment, (String)"environment cannot be null");
        return PropertyAdapter.builder((ConfigurableEnvironment)environment).mapInteger("otel.attribute.value.length.limit", "arconia.otel.logs.limits.max-attribute-value-length").mapInteger("otel.attribute.value.length.limit", "arconia.otel.traces.limits.max-attribute-value-length").mapInteger("otel.attribute.count.limit", "arconia.otel.logs.limits.max-number-of-attributes").mapInteger("otel.attribute.count.limit", "arconia.otel.traces.limits.max-number-of-attributes").build();
    }

    static PropertyAdapter spanLimits(ConfigurableEnvironment environment) {
        Assert.notNull((Object)environment, (String)"environment cannot be null");
        return PropertyAdapter.builder((ConfigurableEnvironment)environment).mapInteger("otel.span.attribute.value.length.limit", "arconia.otel.traces.limits.max-attribute-value-length").mapInteger("otel.span.attribute.count.limit", "arconia.otel.traces.limits.max-number-of-attributes").mapInteger("otel.span.event.count.limit", "arconia.otel.traces.limits.max-number-of-events").mapInteger("otel.span.link.count.limit", "arconia.otel.traces.limits.max-number-of-links").mapInteger("otel.event.attribute.count.limit", "arconia.otel.traces.limits.max-number-of-attributes-per-event").mapInteger("otel.link.attribute.count.limit", "arconia.otel.traces.limits.max-number-of-attributes-per-link").build();
    }

    static PropertyAdapter logRecordLimits(ConfigurableEnvironment environment) {
        Assert.notNull((Object)environment, (String)"environment cannot be null");
        return PropertyAdapter.builder((ConfigurableEnvironment)environment).mapInteger("otel.logrecord.attribute.value.length.limit", "arconia.otel.logs.limits.max-attribute-value-length").mapInteger("otel.logrecord.attribute.count.limit", "arconia.otel.logs.limits.max-number-of-attributes").build();
    }

    static PropertyAdapter exporterSelection(ConfigurableEnvironment environment) {
        Assert.notNull((Object)environment, (String)"environment cannot be null");
        return PropertyAdapter.builder((ConfigurableEnvironment)environment).mapEnum("otel.traces.exporter", "arconia.otel.traces.exporter.type", OpenTelemetryEnvironmentPropertyConverters::exporterType).mapEnum("otel.metrics.exporter", "arconia.otel.metrics.exporter.type", OpenTelemetryEnvironmentPropertyConverters::exporterType).mapEnum("otel.logs.exporter", "arconia.otel.logs.exporter.type", OpenTelemetryEnvironmentPropertyConverters::exporterType).build();
    }

    static PropertyAdapter metrics(ConfigurableEnvironment environment) {
        Assert.notNull((Object)environment, (String)"environment cannot be null");
        return PropertyAdapter.builder((ConfigurableEnvironment)environment).mapEnum("otel.metrics.exemplar.filter", "arconia.otel.metrics.exemplars.filter", OpenTelemetryEnvironmentPropertyConverters::exemplarFilter).mapDuration("otel.metric.export.interval", "arconia.otel.metrics.exporter.interval").mapDuration("otel.metric.export.timeout", "arconia.otel.metrics.exporter.otlp.timeout").build();
    }

    static PropertyAdapter otlpExporter(ConfigurableEnvironment environment) {
        Assert.notNull((Object)environment, (String)"environment cannot be null");
        return PropertyAdapter.builder((ConfigurableEnvironment)environment).mapEnum("otel.exporter.otlp.protocol", "arconia.otel.exporter.otlp.protocol", OpenTelemetryEnvironmentPropertyConverters::protocol).mapString("otel.exporter.otlp.endpoint", "arconia.otel.exporter.otlp.endpoint").mapMap("otel.exporter.otlp.headers", "arconia.otel.exporter.otlp.headers").mapEnum("otel.exporter.otlp.compression", "arconia.otel.exporter.otlp.compression", OpenTelemetryEnvironmentPropertyConverters::compression).mapDuration("otel.exporter.otlp.timeout", "arconia.otel.exporter.otlp.timeout").mapEnum("otel.exporter.otlp.logs.protocol", "arconia.otel.logs.exporter.otlp.protocol", OpenTelemetryEnvironmentPropertyConverters::protocol).mapString("otel.exporter.otlp.logs.endpoint", "arconia.otel.logs.exporter.otlp.endpoint").mapMap("otel.exporter.otlp.logs.headers", "arconia.otel.logs.exporter.otlp.headers").mapEnum("otel.exporter.otlp.logs.compression", "arconia.otel.logs.exporter.otlp.compression", OpenTelemetryEnvironmentPropertyConverters::compression).mapDuration("otel.exporter.otlp.logs.timeout", "arconia.otel.logs.exporter.otlp.timeout").mapEnum("otel.exporter.otlp.metrics.protocol", "arconia.otel.metrics.exporter.otlp.protocol", OpenTelemetryEnvironmentPropertyConverters::protocol).mapString("otel.exporter.otlp.metrics.endpoint", "arconia.otel.metrics.exporter.otlp.endpoint").mapMap("otel.exporter.otlp.metrics.headers", "arconia.otel.metrics.exporter.otlp.headers").mapEnum("otel.exporter.otlp.metrics.compression", "arconia.otel.metrics.exporter.otlp.compression", OpenTelemetryEnvironmentPropertyConverters::compression).mapDuration("otel.exporter.otlp.metrics.timeout", "arconia.otel.metrics.exporter.otlp.timeout").mapEnum("otel.exporter.otlp.traces.protocol", "arconia.otel.traces.exporter.otlp.protocol", OpenTelemetryEnvironmentPropertyConverters::protocol).mapString("otel.exporter.otlp.traces.endpoint", "arconia.otel.traces.exporter.otlp.endpoint").mapMap("otel.exporter.otlp.traces.headers", "arconia.otel.traces.exporter.otlp.headers").mapEnum("otel.exporter.otlp.traces.compression", "arconia.otel.traces.exporter.otlp.compression", OpenTelemetryEnvironmentPropertyConverters::compression).mapDuration("otel.exporter.otlp.traces.timeout", "arconia.otel.traces.exporter.otlp.timeout").build();
    }
}

