/*
 * Decompiled with CFR 0.152.
 */
package io.arconia.opentelemetry.autoconfigure.config;

import io.arconia.opentelemetry.autoconfigure.config.OpenTelemetryEnvironmentPropertyAdapters;
import java.util.HashMap;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.util.Assert;

class OpenTelemetryEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    private static final String PROPERTY_SOURCE_NAME = "opentelemetry-environment-variable-specification";

    OpenTelemetryEnvironmentPostProcessor() {
    }

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        Assert.notNull((Object)environment, (String)"environment cannot be null");
        Boolean enabled = (Boolean)environment.getProperty("arconia.otel.compatibility.environment-variable-specification", Boolean.class, (Object)true);
        if (!enabled.booleanValue()) {
            return;
        }
        HashMap arconiaProperties = new HashMap();
        arconiaProperties.putAll(OpenTelemetryEnvironmentPropertyAdapters.general(environment).getArconiaProperties());
        arconiaProperties.putAll(OpenTelemetryEnvironmentPropertyAdapters.batchSpanProcessor(environment).getArconiaProperties());
        arconiaProperties.putAll(OpenTelemetryEnvironmentPropertyAdapters.logRecordProcessor(environment).getArconiaProperties());
        arconiaProperties.putAll(OpenTelemetryEnvironmentPropertyAdapters.attributeLimits(environment).getArconiaProperties());
        arconiaProperties.putAll(OpenTelemetryEnvironmentPropertyAdapters.spanLimits(environment).getArconiaProperties());
        arconiaProperties.putAll(OpenTelemetryEnvironmentPropertyAdapters.logRecordLimits(environment).getArconiaProperties());
        arconiaProperties.putAll(OpenTelemetryEnvironmentPropertyAdapters.exporterSelection(environment).getArconiaProperties());
        arconiaProperties.putAll(OpenTelemetryEnvironmentPropertyAdapters.metrics(environment).getArconiaProperties());
        arconiaProperties.putAll(OpenTelemetryEnvironmentPropertyAdapters.otlpExporter(environment).getArconiaProperties());
        MapPropertySource propertySource = new MapPropertySource(PROPERTY_SOURCE_NAME, arconiaProperties);
        MutablePropertySources propertySources = environment.getPropertySources();
        propertySources.addFirst((PropertySource)propertySource);
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

