/*
 * Decompiled with CFR 0.152.
 */
package io.arconia.opentelemetry.autoconfigure;

import io.arconia.opentelemetry.autoconfigure.ConditionalOnOpenTelemetry;
import io.arconia.opentelemetry.autoconfigure.OpenTelemetryProperties;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.OpenTelemetrySdkBuilder;
import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.logs.SdkLoggerProvider;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(before={org.springframework.boot.actuate.autoconfigure.opentelemetry.OpenTelemetryAutoConfiguration.class})
@ConditionalOnClass(value={OpenTelemetry.class, OpenTelemetrySdk.class})
@EnableConfigurationProperties(value={OpenTelemetryProperties.class})
public final class OpenTelemetryAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={OpenTelemetry.class})
    @ConditionalOnOpenTelemetry
    OpenTelemetrySdk openTelemetrySdk(ObjectProvider<SdkLoggerProvider> loggerProvider, ObjectProvider<SdkMeterProvider> meterProvider, ObjectProvider<SdkTracerProvider> tracerProvider, ObjectProvider<ContextPropagators> propagators) {
        OpenTelemetrySdkBuilder openTelemetryBuilder = OpenTelemetrySdk.builder();
        loggerProvider.ifAvailable(arg_0 -> ((OpenTelemetrySdkBuilder)openTelemetryBuilder).setLoggerProvider(arg_0));
        meterProvider.ifAvailable(arg_0 -> ((OpenTelemetrySdkBuilder)openTelemetryBuilder).setMeterProvider(arg_0));
        tracerProvider.ifAvailable(arg_0 -> ((OpenTelemetrySdkBuilder)openTelemetryBuilder).setTracerProvider(arg_0));
        propagators.ifAvailable(arg_0 -> ((OpenTelemetrySdkBuilder)openTelemetryBuilder).setPropagators(arg_0));
        return openTelemetryBuilder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnOpenTelemetry(enabled=false)
    OpenTelemetry noopOpenTelemetry() {
        return OpenTelemetry.noop();
    }

    @Bean
    @ConditionalOnMissingBean
    Clock clock() {
        return Clock.getDefault();
    }
}

