/*
 * Decompiled with CFR 0.152.
 */
package io.arconia.opentelemetry.autoconfigure;

import io.arconia.opentelemetry.autoconfigure.ConditionalOnOpenTelemetry;
import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

class OnEnabledOpenTelemetryCondition
extends SpringBootCondition {
    OnEnabledOpenTelemetryCondition() {
    }

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Map attributes = metadata.getAnnotationAttributes(ConditionalOnOpenTelemetry.class.getName());
        boolean checkForEnabled = attributes != null && (Boolean)attributes.get("enabled") != false;
        String openTelemetryEnabledKey = "arconia.otel.enabled";
        Boolean openTelemetryEnabled = (Boolean)context.getEnvironment().getProperty(openTelemetryEnabledKey, Boolean.class);
        if (openTelemetryEnabled != null) {
            boolean enabled = checkForEnabled == openTelemetryEnabled;
            return new ConditionOutcome(enabled, ConditionMessage.forCondition(ConditionalOnOpenTelemetry.class, (Object[])new Object[0]).because(openTelemetryEnabledKey + " is " + openTelemetryEnabled + " and annotation requested enabled to be " + checkForEnabled));
        }
        if (checkForEnabled) {
            return ConditionOutcome.match((ConditionMessage)ConditionMessage.forCondition(ConditionalOnOpenTelemetry.class, (Object[])new Object[0]).because("OpenTelemetry is enabled by default"));
        }
        return ConditionOutcome.noMatch((ConditionMessage)ConditionMessage.forCondition(ConditionalOnOpenTelemetry.class, (Object[])new Object[0]).because("OpenTelemetry is disabled because annotation requested enabled to be false"));
    }
}

