/*
 * Decompiled with CFR 0.152.
 */
package io.arachn.arachnio4j.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.arachn.spi.model.serialization.ArachnioClientModule;
import java.io.IOException;
import java.io.UncheckedIOException;

public final class Jackson {
    public static final ObjectMapper MAPPER = new ObjectMapper().disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).registerModule((Module)new ArachnioClientModule()).registerModule((Module)new JavaTimeModule());

    private Jackson() {
    }

    public static <T> String serialize(T value) {
        try {
            return MAPPER.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException("Failed to serialize value", (IOException)((Object)e));
        }
    }

    public static <T> T deserialize(Class<T> type, String s) {
        try {
            return (T)MAPPER.readValue(s, type);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException("Failed to deserialize value", (IOException)((Object)e));
        }
    }
}

