/*
 * Decompiled with CFR 0.152.
 */
package io.arachn.arachnio4j.client;

import io.arachn.arachnio4j.ArachnioClient;
import io.arachn.arachnio4j.exception.ForbiddenArachnioException;
import io.arachn.arachnio4j.exception.InternalErrorArachnioException;
import io.arachn.arachnio4j.util.Jackson;
import io.arachn.spi.model.DomainName;
import io.arachn.spi.model.DomainNameBatch;
import io.arachn.spi.model.ExtractedLink;
import io.arachn.spi.model.Link;
import io.arachn.spi.model.LinkBatch;
import io.arachn.spi.model.ParsedDomainName;
import io.arachn.spi.model.ParsedDomainNameBatch;
import io.arachn.spi.model.ParsedLink;
import io.arachn.spi.model.ParsedLinkBatch;
import io.arachn.spi.model.UnwoundLink;
import io.arachn.spi.model.UnwoundLinkBatch;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class DefaultArachnioClient
implements ArachnioClient {
    public static final String FREE_PLAN_BASE_URL = "https://api.arachn.io/booh1cxg5suxjets";
    static final String BLOBR_API_KEY_HEADER_NAME = "X-BLOBR-KEY";
    private final HttpClient client;
    private final String baseUrl;
    private final String key;

    public static HttpClient defaultClient() {
        return HttpClient.newHttpClient();
    }

    public DefaultArachnioClient(String baseUrl, String key) {
        this(DefaultArachnioClient.defaultClient(), baseUrl, key);
    }

    public DefaultArachnioClient(HttpClient client, String baseUrl, String key) {
        if (baseUrl == null) {
            throw new NullPointerException();
        }
        if (baseUrl.endsWith("/")) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        this.client = Objects.requireNonNull(client);
        this.baseUrl = baseUrl;
        this.key = Objects.requireNonNull(key);
    }

    @Override
    public ParsedDomainName parseDomainName(DomainName domainName) {
        HttpResponse<String> response;
        try {
            response = this.getClient().send(HttpRequest.newBuilder(URI.create(String.format("%s/domains/parse", this.getBaseUrl()))).header(BLOBR_API_KEY_HEADER_NAME, this.getKey()).POST(HttpRequest.BodyPublishers.ofString(Jackson.serialize(domainName), StandardCharsets.UTF_8)).build(), HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UncheckedIOException("interrupted", new InterruptedIOException());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        if (response.statusCode() == 403) {
            throw new UncheckedIOException(new ForbiddenArachnioException());
        }
        if (response.statusCode() == 400 || response.statusCode() == 422) {
            throw new IllegalArgumentException("invalid domain name");
        }
        if (response.statusCode() == 500) {
            throw new UncheckedIOException(new InternalErrorArachnioException());
        }
        if (response.statusCode() != 200) {
            throw new UncheckedIOException(new IOException("unrecognized failure " + response.statusCode()));
        }
        return Jackson.deserialize(ParsedDomainName.class, response.body());
    }

    @Override
    public ParsedDomainNameBatch parseDomainNameBatch(DomainNameBatch domainNameBatch) {
        HttpResponse<String> response;
        try {
            response = this.getClient().send(HttpRequest.newBuilder(URI.create(String.format("%s/domains/parse/batch", this.getBaseUrl()))).header(BLOBR_API_KEY_HEADER_NAME, this.getKey()).POST(HttpRequest.BodyPublishers.ofString(Jackson.serialize(domainNameBatch), StandardCharsets.UTF_8)).build(), HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UncheckedIOException("interrupted", new InterruptedIOException());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        if (response.statusCode() == 403) {
            throw new UncheckedIOException(new ForbiddenArachnioException());
        }
        if (response.statusCode() == 400 || response.statusCode() == 422) {
            throw new IllegalArgumentException("invalid domain name batch");
        }
        if (response.statusCode() == 500) {
            throw new UncheckedIOException(new InternalErrorArachnioException());
        }
        if (response.statusCode() != 200) {
            throw new UncheckedIOException(new IOException("unrecognized failure " + response.statusCode()));
        }
        return Jackson.deserialize(ParsedDomainNameBatch.class, response.body());
    }

    @Override
    public ExtractedLink extractLink(Link link) {
        HttpResponse<String> response;
        try {
            response = this.getClient().send(HttpRequest.newBuilder(URI.create(String.format("%s/links/extract", this.getBaseUrl()))).header(BLOBR_API_KEY_HEADER_NAME, this.getKey()).POST(HttpRequest.BodyPublishers.ofString(Jackson.serialize(link), StandardCharsets.UTF_8)).build(), HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UncheckedIOException("interrupted", new InterruptedIOException());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        if (response.statusCode() == 403) {
            throw new UncheckedIOException(new ForbiddenArachnioException());
        }
        if (response.statusCode() == 400 || response.statusCode() == 422) {
            throw new IllegalArgumentException("invalid link");
        }
        if (response.statusCode() == 500) {
            throw new UncheckedIOException(new InternalErrorArachnioException());
        }
        if (response.statusCode() != 200) {
            throw new UncheckedIOException(new IOException("unrecognized failure " + response.statusCode()));
        }
        return Jackson.deserialize(ExtractedLink.class, response.body());
    }

    @Override
    public ParsedLink parseLink(Link link) {
        HttpResponse<String> response;
        try {
            response = this.getClient().send(HttpRequest.newBuilder(URI.create(String.format("%s/links/parse", this.getBaseUrl()))).header(BLOBR_API_KEY_HEADER_NAME, this.getKey()).POST(HttpRequest.BodyPublishers.ofString(Jackson.serialize(link), StandardCharsets.UTF_8)).build(), HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UncheckedIOException("interrupted", new InterruptedIOException());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        if (response.statusCode() == 403) {
            throw new UncheckedIOException(new ForbiddenArachnioException());
        }
        if (response.statusCode() == 400 || response.statusCode() == 422) {
            throw new IllegalArgumentException("invalid link");
        }
        if (response.statusCode() == 500) {
            throw new UncheckedIOException(new InternalErrorArachnioException());
        }
        if (response.statusCode() != 200) {
            throw new UncheckedIOException(new IOException("unrecognized failure " + response.statusCode()));
        }
        return Jackson.deserialize(ParsedLink.class, response.body());
    }

    @Override
    public ParsedLinkBatch parseLinkBatch(LinkBatch linkBatch) {
        HttpResponse<String> response;
        try {
            response = this.getClient().send(HttpRequest.newBuilder(URI.create(String.format("%s/links/parse/batch", this.getBaseUrl()))).header(BLOBR_API_KEY_HEADER_NAME, this.getKey()).POST(HttpRequest.BodyPublishers.ofString(Jackson.serialize(linkBatch), StandardCharsets.UTF_8)).build(), HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UncheckedIOException("interrupted", new InterruptedIOException());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        if (response.statusCode() == 403) {
            throw new UncheckedIOException(new ForbiddenArachnioException());
        }
        if (response.statusCode() == 400 || response.statusCode() == 422) {
            throw new IllegalArgumentException("invalid link batch");
        }
        if (response.statusCode() == 500) {
            throw new UncheckedIOException(new InternalErrorArachnioException());
        }
        if (response.statusCode() != 200) {
            throw new UncheckedIOException(new IOException("unrecognized failure " + response.statusCode()));
        }
        return Jackson.deserialize(ParsedLinkBatch.class, response.body());
    }

    @Override
    public UnwoundLink unwindLink(Link link) {
        HttpResponse<String> response;
        try {
            response = this.getClient().send(HttpRequest.newBuilder(URI.create(String.format("%s/links/unwind", this.getBaseUrl()))).header(BLOBR_API_KEY_HEADER_NAME, this.getKey()).POST(HttpRequest.BodyPublishers.ofString(Jackson.serialize(link), StandardCharsets.UTF_8)).build(), HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UncheckedIOException("interrupted", new InterruptedIOException());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        if (response.statusCode() == 403) {
            throw new UncheckedIOException(new ForbiddenArachnioException());
        }
        if (response.statusCode() == 400 || response.statusCode() == 422) {
            throw new IllegalArgumentException("invalid domain name");
        }
        if (response.statusCode() == 500) {
            throw new UncheckedIOException(new InternalErrorArachnioException());
        }
        if (response.statusCode() != 200) {
            throw new UncheckedIOException(new IOException("unrecognized failure " + response.statusCode()));
        }
        return Jackson.deserialize(UnwoundLink.class, response.body());
    }

    @Override
    public UnwoundLinkBatch unwindLinkBatch(LinkBatch linkBatch) {
        HttpResponse<String> response;
        try {
            response = this.getClient().send(HttpRequest.newBuilder(URI.create(String.format("%s/links/unwind/batch", this.getBaseUrl()))).header(BLOBR_API_KEY_HEADER_NAME, this.getKey()).POST(HttpRequest.BodyPublishers.ofString(Jackson.serialize(linkBatch), StandardCharsets.UTF_8)).build(), HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UncheckedIOException("interrupted", new InterruptedIOException());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        if (response.statusCode() == 403) {
            throw new UncheckedIOException(new ForbiddenArachnioException());
        }
        if (response.statusCode() == 400 || response.statusCode() == 422) {
            throw new IllegalArgumentException("invalid link batch");
        }
        if (response.statusCode() == 500) {
            throw new UncheckedIOException(new InternalErrorArachnioException());
        }
        if (response.statusCode() != 200) {
            throw new UncheckedIOException(new IOException("unrecognized failure " + response.statusCode()));
        }
        return Jackson.deserialize(UnwoundLinkBatch.class, response.body());
    }

    private HttpClient getClient() {
        return this.client;
    }

    private String getBaseUrl() {
        return this.baseUrl;
    }

    private String getKey() {
        return this.key;
    }
}

