package io.appmetrica.gradle.repositories

import org.gradle.api.artifacts.dsl.RepositoryHandler
import org.gradle.api.artifacts.repositories.MavenArtifactRepository
import org.gradle.api.publish.PublishingExtension

enum class SonatypeRepo(val url: String) {
    DEFAULT("https://s01.oss.sonatype.org/service/local/staging/deploy/maven2"),
    LEGACY("https://oss.sonatype.org/service/local/staging/deploy/maven2")
}

// repositories extensions

private fun RepositoryHandler.sonatype(
    repositoryName: String = "sonatype",
    repoType: SonatypeRepo = SonatypeRepo.DEFAULT,
    action: MavenArtifactRepository.() -> Unit = {}
): MavenArtifactRepository = maven {
    name = repositoryName
    setUrl(repoType.url)
    withMavenCredentials()
    action()
}

// publishing extensions

fun PublishingExtension.sonatypeRepository(
    name: String = "sonatype",
    repoType: SonatypeRepo = SonatypeRepo.DEFAULT,
    action: MavenArtifactRepository.() -> Unit = {}
): MavenArtifactRepository = repositories.sonatype(name, repoType, action)
