package io.appmetrica.gradle.repositories

import org.gradle.api.Action
import org.gradle.api.artifacts.repositories.MavenArtifactRepository
import org.gradle.api.credentials.PasswordCredentials

open class Credentials(repositoryType: String, repository: MavenArtifactRepository) : Action<PasswordCredentials> {
    private val name: String by lazy {
        if (repository.name.contains(repositoryType, ignoreCase = true)) {
            repository.name
        } else {
            "${repository.name}${repositoryType.capitalize()}"
        }
    }
    private val envPrefix: String by lazy {
        name.replace("[A-Z]".toRegex()) { "_${it.value.toLowerCase()}" }.toUpperCase()
    }
    private val username: String? by lazy {
        System.getProperty("${name}Username") ?: System.getenv("${envPrefix}_USERNAME") ?: System.getenv("USER")
    }
    private val password: String? by lazy {
        System.getProperty("${name}Password") ?: System.getenv("${envPrefix}_PASSWORD")
    }

    override fun execute(credentials: PasswordCredentials) {
        credentials.username = username
        credentials.password = password
    }
}

class MavenCredentials(repository: MavenArtifactRepository) : Credentials("maven", repository)

fun MavenArtifactRepository.withMavenCredentials() {
    credentials(MavenCredentials(this))
}
