package io.appmetrica.gradle.nologs

import com.android.builder.model.SourceProvider
import org.gradle.api.DefaultTask
import org.gradle.api.provider.ListProperty
import org.gradle.api.provider.Property
import org.gradle.api.tasks.Internal
import org.gradle.api.tasks.TaskAction

abstract class RemoveLogsTask : DefaultTask() {

    @get:Internal
    abstract val sources: ListProperty<SourceProvider>

    @get:Internal
    abstract val loggerClasses: ListProperty<String>

    @get:Internal
    abstract val reverse: Property<Boolean>

    @TaskAction
    fun removeLoggers() {
        if (reverse.get()) {
            LoggerCommenter.uncommentLoggers(sources.get())
        } else {
            LoggerCommenter.commentLoggers(sources.get(), loggerClasses.get())
        }
    }
}
