package io.appmetrica.gradle.common.plugins

import org.gradle.api.JavaVersion
import org.gradle.api.Plugin
import org.gradle.api.Project
import org.gradle.api.plugins.JavaLibraryPlugin
import org.gradle.api.plugins.JavaPluginExtension
import org.gradle.kotlin.dsl.apply
import org.gradle.kotlin.dsl.configure
import org.gradle.kotlin.dsl.withType
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginWrapper
import org.jetbrains.kotlin.gradle.tasks.KotlinCompile

class KotlinLibrary : Plugin<Project> {
    override fun apply(target: Project): Unit = target.run {
        apply<JavaLibraryPlugin>()
        apply<KotlinPluginWrapper>()
        apply<CodeQualityPlugin>()

        configureJavaVersion(JavaVersion.VERSION_1_8)
    }

    private fun Project.configureJavaVersion(version: JavaVersion) {
        configure<JavaPluginExtension> {
            sourceCompatibility = version
            targetCompatibility = version
        }
        tasks.withType<KotlinCompile> {
            kotlinOptions.jvmTarget = version.toString()
        }
    }
}
