package io.appmetrica.gradle.plugins

import io.appmetrica.gradle.extensions.GradlePluginDevelopmentFakeExtension
import io.appmetrica.gradle.ktlint.KtLintPlugin
import io.appmetrica.gradle.tasks.ValidatePluginsClasses
import org.gradle.api.Plugin
import org.gradle.api.Project
import org.gradle.api.plugins.ExtensionAware
import org.gradle.api.tasks.SourceSetContainer
import org.gradle.kotlin.dsl.apply
import org.gradle.kotlin.dsl.create
import org.gradle.kotlin.dsl.plugins.dsl.KotlinDslPlugin
import org.gradle.kotlin.dsl.register
import org.gradle.kotlin.dsl.the
import org.gradle.plugin.devel.GradlePluginDevelopmentExtension

class GradlePluginPlugin : Plugin<Project> {
    override fun apply(target: Project): Unit = target.run {
        apply<KotlinDslPlugin>()
        apply<KtLintPlugin>()

        (the<GradlePluginDevelopmentExtension>() as ExtensionAware).extensions
            .create<GradlePluginDevelopmentFakeExtension>("gradle-plugin-fake-extension")

        configureValidatePluginsTask()
    }

    private fun Project.configureValidatePluginsTask() {
        val validatePluginsClasses = tasks.register<ValidatePluginsClasses>("validatePluginsClasses") {
            group = "plugin development"
            classes.setFrom(project.the<SourceSetContainer>().named("main").map { it.output })
        }
        tasks.named("validatePlugins") { dependsOn(validatePluginsClasses) }
    }
}
