package io.appmetrica.gradle.tasks

import org.gradle.api.DefaultTask
import org.gradle.api.file.ConfigurableFileCollection
import org.gradle.api.tasks.IgnoreEmptyDirectories
import org.gradle.api.tasks.InputFiles
import org.gradle.api.tasks.PathSensitive
import org.gradle.api.tasks.PathSensitivity
import org.gradle.api.tasks.SkipWhenEmpty
import org.gradle.api.tasks.TaskAction
import org.gradle.kotlin.dsl.the
import org.gradle.plugin.devel.GradlePluginDevelopmentExtension

// duplicates:
// - <root>/build-logic/src/main/kotlin/io/appmetrica/gradle/tasks/ValidatePluginsClasses.kt
// - <root>/build-logic/build.gradle.kts
abstract class ValidatePluginsClasses : DefaultTask() {
    @get:InputFiles
    @get:SkipWhenEmpty
    @get:IgnoreEmptyDirectories
    @get:PathSensitive(PathSensitivity.RELATIVE)
    abstract val classes: ConfigurableFileCollection

    @TaskAction
    fun validate() {
        val classNames = classes.asFileTree.map { it.canonicalPath.replace("/", ".").removeSuffix(".class") }
        for (plugin in project.the<GradlePluginDevelopmentExtension>().plugins) {
            check(classNames.any { it.endsWith(plugin.implementationClass) }) {
                "Not found implementation class ${plugin.implementationClass} for plugin ${plugin.id}"
            }
        }
    }
}
