package io.appmetrica.gradle.extensions

import org.gradle.api.Project
import org.gradle.api.provider.Provider

fun Project.getPropertyFromParentProjects(name: String, default: String): String {
    var curValue: String? = null
    var curGradle = gradle
    do {
        curGradle.rootProject.findProperty(name)?.let { curValue = it.toString() }
    } while (curGradle.parent?.let { curGradle = it } != null)
    return curValue ?: default
}

fun Project.detectAgpVersion(defaultVersion: String): String {
    return getPropertyFromParentProjects("agp.version", defaultVersion)
}

fun Project.detectAgpVersion(defaultVersion: Provider<String>): String = detectAgpVersion(defaultVersion.get())
