package io.appmetrica.gradle.extensions

import org.gradle.api.Project
import org.gradle.api.plugins.ExtensionAware
import org.gradle.kotlin.dsl.the
import org.gradle.plugin.devel.GradlePluginDevelopmentExtension

// duplicates:
// - <root>/build-logic/src/main/kotlin/io/appmetrica/gradle/extensions/GradlePluginDevelopmentExtensions.kt
// - <root>/build-logic/build.gradle.kts
abstract class GradlePluginDevelopmentFakeExtension(private val project: Project) {
    private val gradlePlugin: GradlePluginDevelopmentExtension
        get() = project.the<GradlePluginDevelopmentExtension>()

    fun plugin(name: String, impl: String) {
        val normalizedName = name.split('.', '-').joinToString("") { it.capitalize() }.decapitalize()
        gradlePlugin.plugins.create(normalizedName) {
            id = "${project.group}.$name"
            implementationClass = impl
        }
    }
}

private val GradlePluginDevelopmentExtension.fakeExtension: GradlePluginDevelopmentFakeExtension
    get() = (this as ExtensionAware).the<GradlePluginDevelopmentFakeExtension>()

fun GradlePluginDevelopmentExtension.plugin(name: String, impl: String) {
    fakeExtension.plugin(name, impl)
}
