package io.appmetrica.gradle.android.plugins

import com.android.build.gradle.LibraryExtension
import com.android.build.gradle.LibraryPlugin
import org.gradle.api.JavaVersion
import org.gradle.api.Plugin
import org.gradle.api.Project
import org.gradle.kotlin.dsl.apply
import org.gradle.kotlin.dsl.configure
import org.gradle.kotlin.dsl.withType
import org.jetbrains.kotlin.gradle.plugin.KotlinAndroidPluginWrapper
import org.jetbrains.kotlin.gradle.tasks.KotlinCompile

class AndroidLibrary : Plugin<Project> {

    override fun apply(project: Project) {
        project.apply<LibraryPlugin>() // id("com.android.library")
        project.apply<KotlinAndroidPluginWrapper>() // id("kotlin-android")
//        project.apply<AndroidCodeQualityPlugin>() // id("appmetrica.android-codequality")

        project.configureJavaVersion(JavaVersion.VERSION_1_7)
    }

    private fun Project.configureJavaVersion(version: JavaVersion) {
        configure<LibraryExtension> {
            @Suppress("UnstableApiUsage")
            compileOptions {
                sourceCompatibility = version
                targetCompatibility = version
            }
        }
        tasks.withType<KotlinCompile> {
            kotlinOptions.jvmTarget = when (version) {
                JavaVersion.VERSION_1_7 -> JavaVersion.VERSION_1_6.toString()
                else -> version.toString()
            }
        }
    }
}
