/*
 * Decompiled with CFR 0.152.
 */
package io.appmetrica.gradle.aarcheck.utils;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.jar.JarEntry;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006\u001a\n\u0010\u0007\u001a\u00020\b*\u00020\t\u001a\u0012\u0010\n\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0006\u00a8\u0006\f"}, d2={"extractEntry", "Ljava/io/File;", "Ljava/util/zip/ZipFile;", "entry", "Ljava/util/zip/ZipEntry;", "entryName", "", "isClass", "", "Ljava/util/jar/JarEntry;", "readFile", "name", "aar-check"})
public final class ZipUtilsKt {
    @NotNull
    public static final File extractEntry(@NotNull ZipFile $this$extractEntry, @NotNull String entryName) {
        Intrinsics.checkNotNullParameter((Object)$this$extractEntry, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)entryName, (String)"entryName");
        ZipEntry zipEntry = $this$extractEntry.getEntry(entryName);
        Intrinsics.checkNotNullExpressionValue((Object)zipEntry, (String)"getEntry(entryName)");
        return ZipUtilsKt.extractEntry($this$extractEntry, zipEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final File extractEntry(@NotNull ZipFile $this$extractEntry, @NotNull ZipEntry entry) {
        Intrinsics.checkNotNullParameter((Object)$this$extractEntry, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        String string = $this$extractEntry.getName();
        String string2 = entry.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"entry.name");
        File entryFile = File.createTempFile(string, StringsKt.replace$default((String)string2, (char)'/', (char)'_', (boolean)false, (int)4, null));
        entryFile.deleteOnExit();
        Closeable closeable = $this$extractEntry.getInputStream(entry);
        Throwable throwable = null;
        try {
            long l;
            InputStream entryInput = (InputStream)closeable;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)entryFile, (String)"entryFile");
            Closeable closeable2 = new FileOutputStream(entryFile);
            Throwable throwable2 = null;
            try {
                FileOutputStream entryFileOutput = (FileOutputStream)closeable2;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)entryInput, (String)"entryInput");
                l = ByteStreamsKt.copyTo$default((InputStream)entryInput, (OutputStream)entryFileOutput, (int)0, (int)2, null);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            long l2 = l;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return entryFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final String readFile(@NotNull ZipFile $this$readFile, @NotNull String name) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$readFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Closeable closeable = $this$readFile.getInputStream($this$readFile.getEntry(name));
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            InputStream inputStream = it;
            Charset charset = Charsets.UTF_8;
            Reader reader = new InputStreamReader(inputStream, charset);
            int n = 8192;
            string = TextStreamsKt.readText((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return string;
    }

    public static final boolean isClass(@NotNull JarEntry $this$isClass) {
        Intrinsics.checkNotNullParameter((Object)$this$isClass, (String)"<this>");
        String string = $this$isClass.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
        return StringsKt.endsWith$default((String)string, (String)".class", (boolean)false, (int)2, null);
    }
}

