/*
 * Decompiled with CFR 0.152.
 */
package io.appmetrica.gradle.aarcheck.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001f2\u00020\u0001:\u0004\u001e\u001f !B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005J\u0016\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005J.\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ\u0010\u0010\u001b\u001a\u00020\u00182\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lio/appmetrica/gradle/aarcheck/utils/ProguardMap;", "", "()V", "mClassesFromClearName", "", "", "Lio/appmetrica/gradle/aarcheck/utils/ProguardMap$ClassData;", "mClassesFromObfuscatedName", "getClassName", "obfuscatedClassName", "getFieldName", "clearClass", "obfuscatedField", "getFrame", "Lio/appmetrica/gradle/aarcheck/utils/ProguardMap$Frame;", "clearClassName", "obfuscatedMethodName", "obfuscatedSignature", "obfuscatedFilename", "obfuscatedLine", "", "getSignature", "obfuscatedSig", "readFromFile", "", "mapFile", "Ljava/io/File;", "readFromReader", "mapReader", "Ljava/io/Reader;", "ClassData", "Companion", "Frame", "FrameData", "aar-check"})
public final class ProguardMap {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, ClassData> mClassesFromClearName = new HashMap();
    @NotNull
    private final Map<String, ClassData> mClassesFromObfuscatedName = new HashMap();
    @NotNull
    private static final String ARRAY_SYMBOL = "[]";

    public final void readFromFile(@Nullable File mapFile) throws FileNotFoundException, IOException, ParseException {
        this.readFromReader(new FileReader(mapFile));
    }

    public final void readFromReader(@Nullable Reader mapReader) throws IOException, ParseException {
        BufferedReader reader = new BufferedReader(mapReader);
        String line = reader.readLine();
        block0: while (line != null) {
            String obfuscatedClassName;
            String clearClassName;
            String trimmed = ((Object)StringsKt.trim((CharSequence)line)).toString();
            if (((CharSequence)trimmed).length() == 0 || StringsKt.startsWith$default((String)trimmed, (String)"#", (boolean)false, (int)2, null)) {
                line = reader.readLine();
                continue;
            }
            int sep = StringsKt.indexOf$default((CharSequence)line, (String)" -> ", (int)0, (boolean)false, (int)6, null);
            if (sep == -1 || sep + 5 >= line.length()) {
                ProguardMap.Companion.parseException("Error parsing class line: '" + line + '\'');
            }
            String string = line;
            int n = 0;
            Intrinsics.checkNotNullExpressionValue((Object)string.substring(n, sep), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String string2 = line;
            int n2 = sep + 4;
            int n3 = line.length() - 1;
            Intrinsics.checkNotNullExpressionValue((Object)string2.substring(n2, n3), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            ClassData classData = new ClassData(clearClassName);
            this.mClassesFromClearName.put(clearClassName, classData);
            this.mClassesFromObfuscatedName.put(obfuscatedClassName, classData);
            line = reader.readLine();
            while (line != null) {
                String obfuscatedName;
                String clearName;
                trimmed = ((Object)StringsKt.trim((CharSequence)line)).toString();
                if (((CharSequence)trimmed).length() == 0 || StringsKt.startsWith$default((String)trimmed, (String)"#", (boolean)false, (int)2, null)) {
                    line = reader.readLine();
                    continue;
                }
                if (!StringsKt.startsWith$default((String)line, (String)"    ", (boolean)false, (int)2, null)) continue block0;
                int ws = StringsKt.indexOf$default((CharSequence)trimmed, (char)' ', (int)0, (boolean)false, (int)6, null);
                sep = StringsKt.indexOf$default((CharSequence)trimmed, (String)" -> ", (int)0, (boolean)false, (int)6, null);
                if (ws == -1 || sep == -1) {
                    ProguardMap.Companion.parseException("Error parse field/method line: '" + line + '\'');
                }
                Intrinsics.checkNotNullExpressionValue((Object)trimmed.substring(0, ws), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                Intrinsics.checkNotNullExpressionValue((Object)trimmed.substring(ws + 1, sep), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                Intrinsics.checkNotNullExpressionValue((Object)trimmed.substring(sep + 4, trimmed.length()), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                if (StringsKt.indexOf$default((CharSequence)clearName, (char)'(', (int)0, (boolean)false, (int)6, null) == -1) {
                    classData.addField(obfuscatedName, clearName);
                } else {
                    String sig;
                    String type;
                    int obfuscatedLine = 0;
                    int colon = StringsKt.indexOf$default((CharSequence)type, (char)':', (int)0, (boolean)false, (int)6, null);
                    if (colon != -1) {
                        String string3 = type.substring(0, colon);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                        obfuscatedLine = Integer.parseInt(string3);
                        String string4 = type.substring(colon + 1);
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
                        type = string4;
                    }
                    if ((colon = StringsKt.indexOf$default((CharSequence)type, (char)':', (int)0, (boolean)false, (int)6, null)) != -1) {
                        String string5 = type.substring(colon + 1);
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).substring(startIndex)");
                        type = string5;
                    }
                    int op = StringsKt.indexOf$default((CharSequence)clearName, (char)'(', (int)0, (boolean)false, (int)6, null);
                    int cp = StringsKt.indexOf$default((CharSequence)clearName, (char)')', (int)0, (boolean)false, (int)6, null);
                    if (op == -1 || cp == -1) {
                        ProguardMap.Companion.parseException("Error parse method line: '" + line + '\'');
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)clearName.substring(op, cp + 1), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    int clearLine = obfuscatedLine;
                    colon = StringsKt.lastIndexOf$default((CharSequence)clearName, (char)':', (int)0, (boolean)false, (int)6, null);
                    if (colon != -1) {
                        String string6 = clearName.substring(colon + 1);
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String).substring(startIndex)");
                        clearLine = Integer.parseInt(string6);
                        String string7 = clearName.substring(0, colon);
                        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                        clearName = string7;
                    }
                    if ((colon = StringsKt.lastIndexOf$default((CharSequence)clearName, (char)':', (int)0, (boolean)false, (int)6, null)) != -1) {
                        String string8 = clearName.substring(colon + 1);
                        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"this as java.lang.String).substring(startIndex)");
                        clearLine = Integer.parseInt(string8);
                        String string9 = clearName.substring(0, colon);
                        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                        clearName = string9;
                    }
                    String string10 = clearName.substring(0, op);
                    Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    clearName = string10;
                    String clearSig = ProguardMap.Companion.fromProguardSignature(sig + type);
                    classData.addFrame(obfuscatedName, clearName, clearSig, obfuscatedLine, clearLine);
                }
                line = reader.readLine();
            }
        }
        reader.close();
    }

    @NotNull
    public final String getClassName(@NotNull String obfuscatedClassName) {
        Intrinsics.checkNotNullParameter((Object)obfuscatedClassName, (String)"obfuscatedClassName");
        String baseName = obfuscatedClassName;
        String arraySuffix = "";
        while (StringsKt.endsWith$default((String)baseName, (String)ARRAY_SYMBOL, (boolean)false, (int)2, null)) {
            arraySuffix = arraySuffix + ARRAY_SYMBOL;
            Intrinsics.checkNotNullExpressionValue((Object)baseName.substring(0, baseName.length() - 2), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        }
        ClassData classData = this.mClassesFromObfuscatedName.get(baseName);
        Object object = classData;
        if (object == null || (object = ((ClassData)object).getClearName()) == null) {
            object = baseName;
        }
        Object clearBaseName = object;
        return (String)clearBaseName + arraySuffix;
    }

    @NotNull
    public final String getFieldName(@NotNull String clearClass, @NotNull String obfuscatedField) {
        Intrinsics.checkNotNullParameter((Object)clearClass, (String)"clearClass");
        Intrinsics.checkNotNullParameter((Object)obfuscatedField, (String)"obfuscatedField");
        ClassData classData = this.mClassesFromClearName.get(clearClass);
        if (classData == null) {
            return obfuscatedField;
        }
        ClassData classData2 = classData;
        return classData2.getField(obfuscatedField);
    }

    @NotNull
    public final Frame getFrame(@NotNull String clearClassName, @NotNull String obfuscatedMethodName, @NotNull String obfuscatedSignature, @NotNull String obfuscatedFilename, int obfuscatedLine) {
        Intrinsics.checkNotNullParameter((Object)clearClassName, (String)"clearClassName");
        Intrinsics.checkNotNullParameter((Object)obfuscatedMethodName, (String)"obfuscatedMethodName");
        Intrinsics.checkNotNullParameter((Object)obfuscatedSignature, (String)"obfuscatedSignature");
        Intrinsics.checkNotNullParameter((Object)obfuscatedFilename, (String)"obfuscatedFilename");
        String clearSignature = this.getSignature(obfuscatedSignature);
        ClassData classData = this.mClassesFromClearName.get(clearClassName);
        if (classData == null) {
            return new Frame(obfuscatedMethodName, clearSignature, obfuscatedFilename, obfuscatedLine);
        }
        ClassData classData2 = classData;
        return classData2.getFrame(clearClassName, obfuscatedMethodName, clearSignature, obfuscatedFilename, obfuscatedLine);
    }

    private final String getSignature(String obfuscatedSig) {
        StringBuilder builder = new StringBuilder();
        for (int i2 = 0; i2 < obfuscatedSig.length(); ++i2) {
            if (obfuscatedSig.charAt(i2) == 'L') {
                int e = StringsKt.indexOf$default((CharSequence)obfuscatedSig, (char)';', (int)i2, (boolean)false, (int)4, null);
                builder.append('L');
                String string = obfuscatedSig.substring(i2 + 1, e);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                String cls = StringsKt.replace$default((String)string, (char)'/', (char)'.', (boolean)false, (int)4, null);
                builder.append(StringsKt.replace$default((String)this.getClassName(cls), (char)'.', (char)'/', (boolean)false, (int)4, null));
                builder.append(';');
                i2 = e;
                continue;
            }
            builder.append(obfuscatedSig.charAt(i2));
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003J.\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013J\u000e\u0010\u0015\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003J0\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\b\u0010\u0019\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0012\u001a\u00020\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lio/appmetrica/gradle/aarcheck/utils/ProguardMap$ClassData;", "", "clearName", "", "(Ljava/lang/String;)V", "getClearName", "()Ljava/lang/String;", "mFields", "", "mFrames", "Lio/appmetrica/gradle/aarcheck/utils/ProguardMap$FrameData;", "addField", "", "obfuscatedName", "addFrame", "obfuscatedMethodName", "clearMethodName", "clearSignature", "obfuscatedLine", "", "clearLine", "getField", "getFrame", "Lio/appmetrica/gradle/aarcheck/utils/ProguardMap$Frame;", "clearClassName", "obfuscatedFilename", "aar-check"})
    private static final class ClassData {
        @NotNull
        private final String clearName;
        @NotNull
        private final Map<String, String> mFields;
        @NotNull
        private final Map<String, FrameData> mFrames;

        public ClassData(@NotNull String clearName) {
            Intrinsics.checkNotNullParameter((Object)clearName, (String)"clearName");
            this.clearName = clearName;
            this.mFields = new HashMap();
            this.mFrames = new HashMap();
        }

        @NotNull
        public final String getClearName() {
            return this.clearName;
        }

        public final void addField(@NotNull String obfuscatedName, @NotNull String clearName) {
            Intrinsics.checkNotNullParameter((Object)obfuscatedName, (String)"obfuscatedName");
            Intrinsics.checkNotNullParameter((Object)clearName, (String)"clearName");
            this.mFields.put(obfuscatedName, clearName);
        }

        @NotNull
        public final String getField(@NotNull String obfuscatedName) {
            Intrinsics.checkNotNullParameter((Object)obfuscatedName, (String)"obfuscatedName");
            String clearField = this.mFields.get(obfuscatedName);
            String string = clearField;
            if (string == null) {
                string = obfuscatedName;
            }
            return string;
        }

        public final void addFrame(@NotNull String obfuscatedMethodName, @NotNull String clearMethodName, @NotNull String clearSignature, int obfuscatedLine, int clearLine) {
            Intrinsics.checkNotNullParameter((Object)obfuscatedMethodName, (String)"obfuscatedMethodName");
            Intrinsics.checkNotNullParameter((Object)clearMethodName, (String)"clearMethodName");
            Intrinsics.checkNotNullParameter((Object)clearSignature, (String)"clearSignature");
            String key = obfuscatedMethodName + clearSignature;
            this.mFrames.put(key, new FrameData(clearMethodName, obfuscatedLine - clearLine));
        }

        @NotNull
        public final Frame getFrame(@NotNull String clearClassName, @NotNull String obfuscatedMethodName, @NotNull String clearSignature, @Nullable String obfuscatedFilename, int obfuscatedLine) {
            Intrinsics.checkNotNullParameter((Object)clearClassName, (String)"clearClassName");
            Intrinsics.checkNotNullParameter((Object)obfuscatedMethodName, (String)"obfuscatedMethodName");
            Intrinsics.checkNotNullParameter((Object)clearSignature, (String)"clearSignature");
            String key = obfuscatedMethodName + clearSignature;
            FrameData frameData = this.mFrames.get(key);
            if (frameData == null) {
                frameData = new FrameData(obfuscatedMethodName, 0);
            }
            FrameData frame = frameData;
            return new Frame(frame.getClearMethodName(), clearSignature, Companion.getFileName(clearClassName), obfuscatedLine - frame.getLineDelta());
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/appmetrica/gradle/aarcheck/utils/ProguardMap$Companion;", "", "()V", "ARRAY_SYMBOL", "", "fromProguardSignature", "sig", "getFileName", "clearClass", "parseException", "", "msg", "aar-check"})
    @SourceDebugExtension(value={"SMAP\nProguardMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProguardMap.kt\nio/appmetrica/gradle/aarcheck/utils/ProguardMap$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,338:1\n731#2,9:339\n37#3,2:348\n*S KotlinDebug\n*F\n+ 1 ProguardMap.kt\nio/appmetrica/gradle/aarcheck/utils/ProguardMap$Companion\n*L\n290#1:339,9\n291#1:348,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final void parseException(String msg) throws ParseException {
            throw new ParseException(msg, 0);
        }

        /*
         * WARNING - void declaration
         */
        private final String fromProguardSignature(String sig) throws ParseException {
            String string;
            if (StringsKt.startsWith$default((String)sig, (String)"(", (boolean)false, (int)2, null)) {
                int end = StringsKt.indexOf$default((CharSequence)sig, (char)')', (int)0, (boolean)false, (int)6, null);
                if (end == -1) {
                    this.parseException("Error parsing signature: " + sig);
                }
                StringBuilder converted = new StringBuilder();
                converted.append('(');
                if (end > 1) {
                    void $this$toTypedArray$iv;
                    List list;
                    Collection $this$dropLastWhile$iv;
                    String string2 = sig.substring(1, end);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    Object object = string2;
                    Regex regex = new Regex(",");
                    int n = 0;
                    object = regex.split((CharSequence)object, n);
                    boolean $i$f$dropLastWhile = false;
                    if (!$this$dropLastWhile$iv.isEmpty()) {
                        ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                        while (iterator$iv.hasPrevious()) {
                            String it = (String)iterator$iv.previous();
                            boolean bl = false;
                            if (((CharSequence)it).length() == 0) continue;
                            list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                            break;
                        }
                    } else {
                        list = CollectionsKt.emptyList();
                    }
                    $this$dropLastWhile$iv = list;
                    boolean $i$f$toTypedArray = false;
                    void thisCollection$iv = $this$toTypedArray$iv;
                    for (String arg : thisCollection$iv.toArray(new String[0])) {
                        converted.append(this.fromProguardSignature(arg));
                    }
                }
                converted.append(')');
                String string3 = sig.substring(end + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
                converted.append(this.fromProguardSignature(string3));
                String string4 = converted.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"{\n                val en\u2026.toString()\n            }");
                string = string4;
            } else if (StringsKt.endsWith$default((String)sig, (String)ProguardMap.ARRAY_SYMBOL, (boolean)false, (int)2, null)) {
                StringBuilder stringBuilder = new StringBuilder().append('[');
                String string5 = sig.substring(0, sig.length() - 2);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                string = stringBuilder.append(this.fromProguardSignature(string5)).toString();
            } else {
                string = Intrinsics.areEqual((Object)sig, (Object)"boolean") ? "Z" : (Intrinsics.areEqual((Object)sig, (Object)"byte") ? "B" : (Intrinsics.areEqual((Object)sig, (Object)"char") ? "C" : (Intrinsics.areEqual((Object)sig, (Object)"short") ? "S" : (Intrinsics.areEqual((Object)sig, (Object)"int") ? "I" : (Intrinsics.areEqual((Object)sig, (Object)"long") ? "J" : (Intrinsics.areEqual((Object)sig, (Object)"float") ? "F" : (Intrinsics.areEqual((Object)sig, (Object)"double") ? "D" : (Intrinsics.areEqual((Object)sig, (Object)"void") ? "V" : 'L' + StringsKt.replace$default((String)sig, (char)'.', (char)'/', (boolean)false, (int)4, null) + ';'))))))));
            }
            return string;
        }

        private final String getFileName(String clearClass) {
            int dollar;
            String filename = clearClass;
            int dot = StringsKt.lastIndexOf$default((CharSequence)filename, (char)'.', (int)0, (boolean)false, (int)6, null);
            if (dot != -1) {
                String string = filename.substring(dot + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                filename = string;
            }
            if ((dollar = StringsKt.indexOf$default((CharSequence)filename, (char)'$', (int)0, (boolean)false, (int)6, null)) != -1) {
                String string = filename.substring(0, dollar);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                filename = string;
            }
            return filename + ".java";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u000f"}, d2={"Lio/appmetrica/gradle/aarcheck/utils/ProguardMap$Frame;", "", "methodName", "", "signature", "filename", "line", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;I)V", "getFilename", "()Ljava/lang/String;", "getLine", "()I", "getMethodName", "getSignature", "aar-check"})
    public static final class Frame {
        @NotNull
        private final String methodName;
        @NotNull
        private final String signature;
        @NotNull
        private final String filename;
        private final int line;

        public Frame(@NotNull String methodName, @NotNull String signature, @NotNull String filename, int line) {
            Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
            this.methodName = methodName;
            this.signature = signature;
            this.filename = filename;
            this.line = line;
        }

        @NotNull
        public final String getMethodName() {
            return this.methodName;
        }

        @NotNull
        public final String getSignature() {
            return this.signature;
        }

        @NotNull
        public final String getFilename() {
            return this.filename;
        }

        public final int getLine() {
            return this.line;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lio/appmetrica/gradle/aarcheck/utils/ProguardMap$FrameData;", "", "clearMethodName", "", "lineDelta", "", "(Ljava/lang/String;I)V", "getClearMethodName", "()Ljava/lang/String;", "setClearMethodName", "(Ljava/lang/String;)V", "getLineDelta", "()I", "setLineDelta", "(I)V", "aar-check"})
    private static final class FrameData {
        @NotNull
        private String clearMethodName;
        private int lineDelta;

        public FrameData(@NotNull String clearMethodName, int lineDelta) {
            Intrinsics.checkNotNullParameter((Object)clearMethodName, (String)"clearMethodName");
            this.clearMethodName = clearMethodName;
            this.lineDelta = lineDelta;
        }

        @NotNull
        public final String getClearMethodName() {
            return this.clearMethodName;
        }

        public final void setClearMethodName(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.clearMethodName = string;
        }

        public final int getLineDelta() {
            return this.lineDelta;
        }

        public final void setLineDelta(int n) {
            this.lineDelta = n;
        }
    }
}

