/*
 * Decompiled with CFR 0.152.
 */
package io.appmetrica.gradle.aarcheck.tasks;

import io.appmetrica.gradle.aarcheck.kotlinassertions.ForbiddenMethodsChecker;
import java.io.File;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\u000eH\u0007R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R&\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\n0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Lio/appmetrica/gradle/aarcheck/tasks/MethodsCheck;", "Lorg/gradle/api/DefaultTask;", "()V", "aarFile", "Lorg/gradle/api/file/RegularFileProperty;", "getAarFile", "()Lorg/gradle/api/file/RegularFileProperty;", "forbiddenMethods", "Lorg/gradle/api/provider/MapProperty;", "", "", "getForbiddenMethods", "()Lorg/gradle/api/provider/MapProperty;", "check", "", "aar-check"})
public abstract class MethodsCheck
extends DefaultTask {
    @InputFile
    @NotNull
    public abstract RegularFileProperty getAarFile();

    @Input
    @NotNull
    public abstract MapProperty<String, List<String>> getForbiddenMethods();

    @TaskAction
    public final void check() {
        this.getLogger().info("Check forbidden methods in " + this.getAarFile().get());
        File file = ((RegularFile)this.getAarFile().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"aarFile.get().asFile");
        Object object = this.getForbiddenMethods().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"forbiddenMethods.get()");
        ForbiddenMethodsChecker.INSTANCE.check(file, (Map)object);
    }
}

