/*
 * Decompiled with CFR 0.152.
 */
package io.appmetrica.gradle.aarcheck.tasks;

import io.appmetrica.gradle.aarcheck.manifest.ManifestChecker;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0007R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Lio/appmetrica/gradle/aarcheck/tasks/ManifestCheck;", "Lorg/gradle/api/DefaultTask;", "()V", "aarFile", "Lorg/gradle/api/file/RegularFileProperty;", "getAarFile", "()Lorg/gradle/api/file/RegularFileProperty;", "manifestDumpFile", "getManifestDumpFile", "versionCode", "Lorg/gradle/api/provider/Property;", "", "getVersionCode", "()Lorg/gradle/api/provider/Property;", "check", "", "aar-check"})
public abstract class ManifestCheck
extends DefaultTask {
    @InputFile
    @NotNull
    public abstract RegularFileProperty getAarFile();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getVersionCode();

    @InputFile
    @NotNull
    public abstract RegularFileProperty getManifestDumpFile();

    @TaskAction
    public final void check() {
        this.getLogger().info("Check manifest for " + this.getAarFile().get());
        ManifestChecker manifestChecker = new ManifestChecker(true, (String)this.getVersionCode().getOrNull());
        File file = ((RegularFile)this.getAarFile().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"aarFile.get().asFile");
        File file2 = ((RegularFile)this.getManifestDumpFile().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"manifestDumpFile.get().asFile");
        manifestChecker.check(file, file2);
    }
}

