/*
 * Decompiled with CFR 0.152.
 */
package io.appmetrica.gradle.aarcheck.tasks;

import io.appmetrica.gradle.aarcheck.AarCheckException;
import io.appmetrica.gradle.aarcheck.agp.AndroidLibraryVariant;
import io.appmetrica.gradle.aarcheck.dependencies.DependenciesExtractor;
import io.appmetrica.gradle.aarcheck.utils.DiffUtils;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\f\u001a\u00020\rH\u0007R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lio/appmetrica/gradle/aarcheck/tasks/DependenciesCheck;", "Lorg/gradle/api/DefaultTask;", "()V", "androidLibraryVariant", "Lorg/gradle/api/provider/Property;", "Lio/appmetrica/gradle/aarcheck/agp/AndroidLibraryVariant;", "getAndroidLibraryVariant", "()Lorg/gradle/api/provider/Property;", "dependenciesDumpFile", "Lorg/gradle/api/file/RegularFileProperty;", "getDependenciesDumpFile", "()Lorg/gradle/api/file/RegularFileProperty;", "check", "", "aar-check"})
public abstract class DependenciesCheck
extends DefaultTask {
    @Internal
    @NotNull
    public abstract Property<AndroidLibraryVariant> getAndroidLibraryVariant();

    @InputFile
    @NotNull
    public abstract RegularFileProperty getDependenciesDumpFile();

    @TaskAction
    public final void check() {
        this.getLogger().info("Check dependencies for " + ((AndroidLibraryVariant)this.getAndroidLibraryVariant().get()).getName());
        File file = ((RegularFile)this.getDependenciesDumpFile().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"dependenciesDumpFile.get().asFile");
        File dumpFile = file;
        if (!dumpFile.exists()) {
            throw new AarCheckException("Dependencies check failed. Not found file " + dumpFile.getCanonicalPath() + ". You can run :dependenciesDump task to generate dependencies dump");
        }
        String dump = FilesKt.readText$default((File)dumpFile, null, (int)1, null);
        Object object = this.getAndroidLibraryVariant().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"androidLibraryVariant.get()");
        String expected = DependenciesExtractor.INSTANCE.extract((AndroidLibraryVariant)object);
        String diff = DiffUtils.INSTANCE.diff(dump, expected, "dump dependencies", "cur dependencies");
        if (diff != null) {
            this.getLogger().error("Diff:\n" + diff);
            throw new AarCheckException("Dependencies check failed. See diff above. You can run :dependenciesDump task to overwrite dependencies dump");
        }
    }
}

