/*
 * Decompiled with CFR 0.152.
 */
package io.appmetrica.gradle.aarcheck.tasks;

import io.appmetrica.gradle.aarcheck.api.ApiChecker;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0007R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lio/appmetrica/gradle/aarcheck/tasks/ApiCheck;", "Lorg/gradle/api/DefaultTask;", "()V", "aarFile", "Lorg/gradle/api/file/RegularFileProperty;", "getAarFile", "()Lorg/gradle/api/file/RegularFileProperty;", "apiDumpFile", "getApiDumpFile", "mappingFile", "getMappingFile", "packageName", "Lorg/gradle/api/provider/Property;", "", "getPackageName", "()Lorg/gradle/api/provider/Property;", "check", "", "aar-check"})
public abstract class ApiCheck
extends DefaultTask {
    @InputFile
    @NotNull
    public abstract RegularFileProperty getAarFile();

    @InputFile
    @Optional
    @NotNull
    public abstract RegularFileProperty getMappingFile();

    @InputFile
    @NotNull
    public abstract RegularFileProperty getApiDumpFile();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getPackageName();

    @TaskAction
    public final void check() {
        this.getLogger().info("Check api for " + this.getAarFile().get());
        File file = ((RegularFile)this.getAarFile().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"aarFile.get().asFile");
        ApiChecker.INSTANCE.checkPackage(file, (String)this.getPackageName().getOrNull());
        File file2 = ((RegularFile)this.getAarFile().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"aarFile.get().asFile");
        File file3 = ((RegularFile)this.getApiDumpFile().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"apiDumpFile.get().asFile");
        RegularFile regularFile = (RegularFile)this.getMappingFile().getOrNull();
        ApiChecker.INSTANCE.check(file2, file3, regularFile != null ? regularFile.getAsFile() : null);
    }
}

