/*
 * Decompiled with CFR 0.152.
 */
package io.appmetrica.gradle.aarcheck.proguard;

import io.appmetrica.gradle.aarcheck.AarCheckException;
import io.appmetrica.gradle.aarcheck.proguard.ProguardExtractor;
import io.appmetrica.gradle.aarcheck.utils.DiffUtils;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lio/appmetrica/gradle/aarcheck/proguard/ProguardChecker;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "check", "", "aarFile", "Ljava/io/File;", "proguardDumpFile", "aar-check"})
public final class ProguardChecker {
    private final Logger logger = LoggerFactory.getLogger((String)"aar-check");

    public final void check(@NotNull File aarFile, @NotNull File proguardDumpFile) {
        String proguard;
        Intrinsics.checkNotNullParameter((Object)aarFile, (String)"aarFile");
        Intrinsics.checkNotNullParameter((Object)proguardDumpFile, (String)"proguardDumpFile");
        if (!proguardDumpFile.exists()) {
            throw new AarCheckException("Proguard check failed. Not found file " + proguardDumpFile.getCanonicalPath() + ". You can run :proguardDump task to generate proguard dump");
        }
        String proguardDump = FilesKt.readText$default((File)proguardDumpFile, null, (int)1, null);
        String diff = DiffUtils.INSTANCE.diff(proguardDump, proguard = ProguardExtractor.INSTANCE.extract(aarFile), "dump proguard", "cur proguard");
        if (diff != null) {
            this.logger.error("Diff:\n" + diff);
            throw new AarCheckException("Proguard check failed. See diff above. You can run :proguardDump task to overwrite proguard dump");
        }
    }
}

