/*
 * Decompiled with CFR 0.152.
 */
package io.appmetrica.gradle.aarcheck.pom;

import io.appmetrica.gradle.aarcheck.AarCheckException;
import io.appmetrica.gradle.aarcheck.utils.DiffUtils;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lio/appmetrica/gradle/aarcheck/pom/PomChecker;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "check", "", "dumpFile", "Ljava/io/File;", "pomFile", "aar-check"})
public final class PomChecker {
    @NotNull
    public static final PomChecker INSTANCE = new PomChecker();
    private static final Logger logger = LoggerFactory.getLogger((String)"aar-check");

    private PomChecker() {
    }

    public final void check(@NotNull File dumpFile, @NotNull File pomFile) {
        String pom;
        Intrinsics.checkNotNullParameter((Object)dumpFile, (String)"dumpFile");
        Intrinsics.checkNotNullParameter((Object)pomFile, (String)"pomFile");
        if (!dumpFile.exists()) {
            throw new AarCheckException("Pom check failed. Not found file " + dumpFile.getCanonicalPath() + ". You can run :pomDump task to generate pom dump");
        }
        String dump = FilesKt.readText$default((File)dumpFile, null, (int)1, null);
        String diff = DiffUtils.INSTANCE.diff(dump, pom = FilesKt.readText$default((File)pomFile, null, (int)1, null), "dump pom", "cur pom");
        if (diff != null) {
            logger.error("Diff:\n" + diff);
            throw new AarCheckException("Pom check failed. See diff above. You can run :pomDump task to overwrite pom dump");
        }
    }
}

