/*
 * Decompiled with CFR 0.152.
 */
package io.appmetrica.gradle.aarcheck.manifest;

import io.appmetrica.gradle.aarcheck.utils.ZipUtilsKt;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import org.apache.tools.ant.filters.ReplaceTokens;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tJ \u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tJ\"\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00072\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/appmetrica/gradle/aarcheck/manifest/ManifestExtractor;", "", "()V", "VERSION_CODE_TOKEN", "", "extract", "aarFile", "Ljava/io/File;", "asTemplate", "", "extractToFile", "", "manifestDumpFile", "fromTemplate", "file", "params", "", "aar-check"})
public final class ManifestExtractor {
    @NotNull
    public static final ManifestExtractor INSTANCE = new ManifestExtractor();
    @NotNull
    public static final String VERSION_CODE_TOKEN = "version_code";

    private ManifestExtractor() {
    }

    public final void extractToFile(@NotNull File aarFile, @NotNull File manifestDumpFile, boolean asTemplate) {
        Intrinsics.checkNotNullParameter((Object)aarFile, (String)"aarFile");
        Intrinsics.checkNotNullParameter((Object)manifestDumpFile, (String)"manifestDumpFile");
        FilesKt.writeText$default((File)manifestDumpFile, (String)this.extract(aarFile, asTemplate), null, (int)2, null);
    }

    public static /* synthetic */ void extractToFile$default(ManifestExtractor manifestExtractor, File file, File file2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        manifestExtractor.extractToFile(file, file2, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String extract(@NotNull File aarFile, boolean asTemplate) {
        Intrinsics.checkNotNullParameter((Object)aarFile, (String)"aarFile");
        Closeable closeable = new ZipFile(aarFile);
        Throwable throwable = null;
        try {
            ZipFile zipFile = (ZipFile)closeable;
            boolean bl = false;
            String manifest = ZipUtilsKt.readFile(zipFile, "AndroidManifest.xml");
            if (asTemplate) {
                CharSequence charSequence = manifest;
                Regex regex = new Regex("android:versionCode=\"\\d+\"");
                String string = "android:versionCode=\"<version_code>\"";
                manifest = regex.replace(charSequence, string);
            }
            String string = manifest;
            return string;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ String extract$default(ManifestExtractor manifestExtractor, File file, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return manifestExtractor.extract(file, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final String fromTemplate(@NotNull File file, @NotNull Map<String, String> params) {
        String string;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(params, (String)"params");
        Object object = file;
        Object object2 = Charsets.UTF_8;
        object = new InputStreamReader((InputStream)new FileInputStream((File)object), (Charset)object2);
        object2 = null;
        try {
            ReplaceTokens replaceTokens;
            InputStreamReader it = (InputStreamReader)object;
            boolean bl = false;
            ReplaceTokens $this$fromTemplate_u24lambda_u243_u24lambda_u242 = replaceTokens = new ReplaceTokens((Reader)it);
            boolean bl2 = false;
            $this$fromTemplate_u24lambda_u243_u24lambda_u242.setBeginToken("<");
            $this$fromTemplate_u24lambda_u243_u24lambda_u242.setEndToken(">");
            for (Map.Entry<String, String> entry : params.entrySet()) {
                void $this$fromTemplate_u24lambda_u243_u24lambda_u242_u24lambda_u241;
                ReplaceTokens.Token token;
                String key = entry.getKey();
                String value = entry.getValue();
                ReplaceTokens.Token token2 = token = new ReplaceTokens.Token();
                ReplaceTokens replaceTokens2 = $this$fromTemplate_u24lambda_u243_u24lambda_u242;
                boolean bl3 = false;
                $this$fromTemplate_u24lambda_u243_u24lambda_u242_u24lambda_u241.setKey(key);
                $this$fromTemplate_u24lambda_u243_u24lambda_u242_u24lambda_u241.setValue(value);
                replaceTokens2.addConfiguredToken(token);
            }
            string = TextStreamsKt.readText((Reader)((Reader)replaceTokens));
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        return string;
    }
}

