/*
 * Decompiled with CFR 0.152.
 */
package io.appmetrica.gradle.aarcheck.manifest;

import io.appmetrica.gradle.aarcheck.AarCheckException;
import io.appmetrica.gradle.aarcheck.manifest.ManifestExtractor;
import io.appmetrica.gradle.aarcheck.utils.DiffUtils;
import java.io.File;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/appmetrica/gradle/aarcheck/manifest/ManifestChecker;", "", "fullCheck", "", "versionCode", "", "(ZLjava/lang/String;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "check", "", "aarFile", "Ljava/io/File;", "manifestDumpFile", "aar-check"})
@SourceDebugExtension(value={"SMAP\nManifestChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ManifestChecker.kt\nio/appmetrica/gradle/aarcheck/manifest/ManifestChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,44:1\n1#2:45\n*E\n"})
public final class ManifestChecker {
    private final boolean fullCheck;
    @Nullable
    private final String versionCode;
    private final Logger logger;

    public ManifestChecker(boolean fullCheck, @Nullable String versionCode2) {
        this.fullCheck = fullCheck;
        this.versionCode = versionCode2;
        this.logger = LoggerFactory.getLogger((String)"aar-check");
    }

    public /* synthetic */ ManifestChecker(boolean bl, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            string = null;
        }
        this(bl, string);
    }

    /*
     * WARNING - void declaration
     */
    public final void check(@NotNull File aarFile, @NotNull File manifestDumpFile) {
        String string;
        Intrinsics.checkNotNullParameter((Object)aarFile, (String)"aarFile");
        Intrinsics.checkNotNullParameter((Object)manifestDumpFile, (String)"manifestDumpFile");
        if (!manifestDumpFile.exists()) {
            throw new AarCheckException("Manifest check failed. Not found file " + manifestDumpFile.getCanonicalPath() + ". You can run :manifestDump task to generate AndroidManifest dump");
        }
        if (this.fullCheck) {
            Pair pair;
            ManifestExtractor manifestExtractor = ManifestExtractor.INSTANCE;
            File file = manifestDumpFile;
            String string2 = this.versionCode;
            if (string2 != null) {
                void it;
                String string3 = string2;
                File file2 = file;
                ManifestExtractor manifestExtractor2 = manifestExtractor;
                boolean bl = false;
                Pair pair2 = TuplesKt.to((Object)"version_code", (Object)it);
                manifestExtractor = manifestExtractor2;
                file = file2;
                pair = pair2;
            } else {
                pair = null;
            }
            string = manifestExtractor.fromTemplate(file, MapsKt.toMap((Iterable)CollectionsKt.listOfNotNull(pair)));
        } else {
            string = FilesKt.readText$default((File)manifestDumpFile, null, (int)1, null);
        }
        String manifestDump = string;
        String manifest = ManifestExtractor.INSTANCE.extract(aarFile, !this.fullCheck);
        String diff = DiffUtils.INSTANCE.diff(manifestDump, manifest, "dump manifest", "cur manifest");
        if (diff != null) {
            this.logger.error("Diff:\n" + diff);
            throw new AarCheckException("Manifest check failed. See diff above. You can run :manifestDump task to overwrite AndroidManifest dump");
        }
    }

    public ManifestChecker() {
        this(false, null, 3, null);
    }
}

