/*
 * Decompiled with CFR 0.152.
 */
package io.appmetrica.gradle.aarcheck.kotlinassertions;

import io.appmetrica.gradle.aarcheck.AarCheckException;
import io.appmetrica.gradle.aarcheck.utils.NamesUtils;
import io.appmetrica.gradle.aarcheck.utils.ZipUtilsKt;
import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.bytecode.ConstPool;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\n0\b\u00a8\u0006\u000b"}, d2={"Lio/appmetrica/gradle/aarcheck/kotlinassertions/ForbiddenMethodsChecker;", "", "()V", "check", "", "aarFile", "Ljava/io/File;", "forbiddenMethods", "", "", "", "aar-check"})
@SourceDebugExtension(value={"SMAP\nForbiddenMethodsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ForbiddenMethodsChecker.kt\nio/appmetrica/gradle/aarcheck/kotlinassertions/ForbiddenMethodsChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,53:1\n766#2:54\n857#2,2:55\n*S KotlinDebug\n*F\n+ 1 ForbiddenMethodsChecker.kt\nio/appmetrica/gradle/aarcheck/kotlinassertions/ForbiddenMethodsChecker\n*L\n32#1:54\n32#1:55,2\n*E\n"})
public final class ForbiddenMethodsChecker {
    @NotNull
    public static final ForbiddenMethodsChecker INSTANCE = new ForbiddenMethodsChecker();

    private ForbiddenMethodsChecker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void check(@NotNull File aarFile, @NotNull Map<String, ? extends List<String>> forbiddenMethods) {
        Intrinsics.checkNotNullParameter((Object)aarFile, (String)"aarFile");
        Intrinsics.checkNotNullParameter(forbiddenMethods, (String)"forbiddenMethods");
        if (forbiddenMethods.isEmpty()) {
            return;
        }
        Closeable closeable = new ZipFile(aarFile);
        Throwable throwable = null;
        try {
            ZipFile zipFile = (ZipFile)closeable;
            boolean bl = false;
            Closeable closeable2 = new JarFile(ZipUtilsKt.extractEntry(zipFile, "classes.jar"));
            Throwable throwable2 = null;
            try {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                JarFile jarFile = (JarFile)closeable2;
                boolean bl2 = false;
                ClassPool classPool = new ClassPool();
                classPool.appendClassPath(jarFile.getName());
                Enumeration<JarEntry> enumeration = jarFile.entries();
                Intrinsics.checkNotNullExpressionValue(enumeration, (String)"jarFile.entries()");
                ArrayList<JarEntry> arrayList = Collections.list(enumeration);
                Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(this)");
                Iterable iterable = arrayList;
                boolean $i$f$filter = false;
                void var14_19 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    JarEntry p0 = (JarEntry)element$iv$iv;
                    boolean bl3 = false;
                    if (!ZipUtilsKt.isClass(p0)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                for (JarEntry jarEntry : (List)destination$iv$iv) {
                    String string = jarEntry.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jarEntry.name");
                    CtClass ctClass = classPool.get(NamesUtils.INSTANCE.getFullClassName(string));
                    ConstPool constPool = ctClass.getClassFile().getConstPool();
                    int n = constPool.getSize();
                    for (int index = 1; index < n; ++index) {
                        List<String> methods;
                        String className;
                        if (constPool.getTag(index) != 10 || forbiddenMethods.get(className = constPool.getMethodrefClassName(index)) == null || !methods.contains(constPool.getMethodrefName(index))) continue;
                        throw new AarCheckException("Found forbidden method - " + className + '.' + constPool.getMethodrefName(index) + " in class - " + ctClass.getName());
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

