/*
 * Decompiled with CFR 0.152.
 */
package io.appmetrica.gradle.aarcheck.imports;

import io.appmetrica.gradle.aarcheck.AarCheckException;
import io.appmetrica.gradle.aarcheck.utils.NamesUtils;
import io.appmetrica.gradle.aarcheck.utils.ZipUtilsKt;
import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import javassist.ClassPool;
import javassist.CtClass;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a8\u0006\n"}, d2={"Lio/appmetrica/gradle/aarcheck/imports/ImportChecker;", "", "()V", "check", "", "aarFile", "Ljava/io/File;", "forbiddenImports", "", "", "aar-check"})
@SourceDebugExtension(value={"SMAP\nImportChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImportChecker.kt\nio/appmetrica/gradle/aarcheck/imports/ImportChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,38:1\n1549#2:39\n1620#2,3:40\n766#2:43\n857#2,2:44\n*S KotlinDebug\n*F\n+ 1 ImportChecker.kt\nio/appmetrica/gradle/aarcheck/imports/ImportChecker\n*L\n17#1:39\n17#1:40,3\n23#1:43\n23#1:44,2\n*E\n"})
public final class ImportChecker {
    @NotNull
    public static final ImportChecker INSTANCE = new ImportChecker();

    private ImportChecker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void check(@NotNull File aarFile, @NotNull List<String> forbiddenImports) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)aarFile, (String)"aarFile");
        Intrinsics.checkNotNullParameter(forbiddenImports, (String)"forbiddenImports");
        if (forbiddenImports.isEmpty()) {
            return;
        }
        Object object = forbiddenImports;
        Object object2 = NamesUtils.INSTANCE;
        boolean $i$f$map = false;
        void var7_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(((NamesUtils)object2).unfixPackageName((String)p0));
        }
        List imports = (List)destination$iv$iv;
        object = new ZipFile(aarFile);
        object2 = null;
        try {
            ZipFile zipFile = (ZipFile)object;
            boolean bl = false;
            Closeable closeable = new JarFile(ZipUtilsKt.extractEntry(zipFile, "classes.jar"));
            Throwable throwable = null;
            try {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                JarFile jarFile = (JarFile)closeable;
                boolean bl2 = false;
                ClassPool classPool = new ClassPool();
                classPool.appendClassPath(jarFile.getName());
                Enumeration<JarEntry> enumeration = jarFile.entries();
                Intrinsics.checkNotNullExpressionValue(enumeration, (String)"jarFile.entries()");
                ArrayList<JarEntry> arrayList = Collections.list(enumeration);
                Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(this)");
                Iterable bl3 = arrayList;
                boolean $i$f$filter = false;
                void var15_26 = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    JarEntry p0 = (JarEntry)element$iv$iv;
                    boolean bl4 = false;
                    if (!ZipUtilsKt.isClass(p0)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                for (JarEntry jarEntry : (List)destination$iv$iv2) {
                    String string = jarEntry.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jarEntry.name");
                    if (imports.contains(StringsKt.dropLast((String)string, (int)6))) continue;
                    String string2 = jarEntry.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"jarEntry.name");
                    CtClass ctClass = classPool.get(NamesUtils.INSTANCE.getFullClassName(string2));
                    Iterable iterable = imports;
                    Set set = ctClass.getClassFile().getConstPool().getClassNames();
                    Intrinsics.checkNotNullExpressionValue((Object)set, (String)"ctClass.classFile.constPool.classNames");
                    Set forbiddenImportsFound = CollectionsKt.intersect((Iterable)iterable, (Iterable)set);
                    if (!(!((Collection)forbiddenImportsFound).isEmpty())) continue;
                    Object object3 = CollectionsKt.first((Iterable)forbiddenImportsFound);
                    Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"forbiddenImportsFound.first()");
                    String forbiddenImport = NamesUtils.INSTANCE.fixPackageName((String)object3);
                    throw new AarCheckException("Found forbidden import '" + forbiddenImport + "' in '" + ctClass.getName() + '\'');
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
    }
}

