/*
 * Decompiled with CFR 0.152.
 */
package io.appmetrica.gradle.aarcheck.api;

import io.appmetrica.gradle.aarcheck.api.Class;
import io.appmetrica.gradle.aarcheck.api.Field;
import io.appmetrica.gradle.aarcheck.api.Method;
import io.appmetrica.gradle.aarcheck.api.Type;
import io.appmetrica.gradle.aarcheck.utils.MappingFile;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/appmetrica/gradle/aarcheck/api/NameProvider;", "", "mappingFile", "Lio/appmetrica/gradle/aarcheck/utils/MappingFile;", "(Lio/appmetrica/gradle/aarcheck/utils/MappingFile;)V", "getClassName", "", "clazz", "Lio/appmetrica/gradle/aarcheck/api/Class;", "type", "Lio/appmetrica/gradle/aarcheck/api/Type;", "getClearClassName", "getClearFieldName", "field", "Lio/appmetrica/gradle/aarcheck/api/Field;", "getClearMethodName", "method", "Lio/appmetrica/gradle/aarcheck/api/Method;", "getFieldName", "getMethodName", "aar-check"})
public final class NameProvider {
    @Nullable
    private final MappingFile mappingFile;

    public NameProvider(@Nullable MappingFile mappingFile) {
        this.mappingFile = mappingFile;
    }

    @NotNull
    public final String getClearClassName(@NotNull Type type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Object object = this.mappingFile;
        if (object == null || (object = ((MappingFile)object).getClassName(type.getFullName())) == null) {
            object = type.getFullName();
        }
        return object;
    }

    @NotNull
    public final String getClassName(@NotNull Type type) {
        String string;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        String name = this.getClearClassName(type);
        if (Intrinsics.areEqual((Object)name, (Object)type.getFullName())) {
            string = name;
        } else {
            String string2 = "OBFUSCATED[%s]";
            Object[] objectArray = new Object[]{name};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(this, *args)");
        }
        return string;
    }

    @NotNull
    public final String getClearClassName(@NotNull Class clazz) {
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        Object object = this.mappingFile;
        if (object == null || (object = ((MappingFile)object).getClassName(clazz.getFullName())) == null) {
            object = clazz.getFullName();
        }
        return object;
    }

    @NotNull
    public final String getClassName(@NotNull Class clazz) {
        String string;
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        String name = this.getClearClassName(clazz);
        if (Intrinsics.areEqual((Object)name, (Object)clazz.getFullName())) {
            string = name;
        } else {
            String string2 = "OBFUSCATED[%s]";
            Object[] objectArray = new Object[]{name};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(this, *args)");
        }
        return string;
    }

    @NotNull
    public final String getClearFieldName(@NotNull Field field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        String clearClassName = this.getClearClassName(field.getDeclaringClass());
        Object object = this.mappingFile;
        if (object == null || (object = ((MappingFile)object).getFieldName(clearClassName, field.getName())) == null) {
            object = field.getName();
        }
        return object;
    }

    @NotNull
    public final String getFieldName(@NotNull Field field) {
        String string;
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        String name = this.getClearFieldName(field);
        if (Intrinsics.areEqual((Object)name, (Object)field.getName())) {
            string = name;
        } else {
            String string2 = "OBFUSCATED[%s]";
            Object[] objectArray = new Object[]{name};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(this, *args)");
        }
        return string;
    }

    @NotNull
    public final String getClearMethodName(@NotNull Method method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        String className = this.getClearClassName(method.getDeclaringClass());
        Object object = this.mappingFile;
        if (object == null || (object = ((MappingFile)object).getMethodName(className, method.getName(), method.getNativeSignature())) == null) {
            object = method.getName();
        }
        return object;
    }

    @NotNull
    public final String getMethodName(@NotNull Method method) {
        String string;
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        String name = this.getClearMethodName(method);
        if (Intrinsics.areEqual((Object)name, (Object)method.getName())) {
            string = name;
        } else {
            String string2 = "OBFUSCATED[%s]";
            Object[] objectArray = new Object[]{name};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(this, *args)");
        }
        return string;
    }
}

