/*
 * Decompiled with CFR 0.152.
 */
package io.appmetrica.gradle.aarcheck.api;

import io.appmetrica.gradle.aarcheck.AarCheckException;
import io.appmetrica.gradle.aarcheck.api.ApiGenerator;
import io.appmetrica.gradle.aarcheck.api.Class;
import io.appmetrica.gradle.aarcheck.api.parser.javassist.JavassistParser;
import io.appmetrica.gradle.aarcheck.utils.DiffUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\tJ\u001a\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/appmetrica/gradle/aarcheck/api/ApiChecker;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "check", "", "aarFile", "Ljava/io/File;", "apiFile", "mappingFile", "checkPackage", "packageName", "", "aar-check"})
@SourceDebugExtension(value={"SMAP\nApiChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApiChecker.kt\nio/appmetrica/gradle/aarcheck/api/ApiChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,52:1\n819#2:53\n847#2,2:54\n*S KotlinDebug\n*F\n+ 1 ApiChecker.kt\nio/appmetrica/gradle/aarcheck/api/ApiChecker\n*L\n43#1:53\n43#1:54,2\n*E\n"})
public final class ApiChecker {
    @NotNull
    public static final ApiChecker INSTANCE = new ApiChecker();
    private static final Logger logger = LoggerFactory.getLogger((String)"aar-check");

    private ApiChecker() {
    }

    public final void check(@NotNull File aarFile, @NotNull File apiFile, @Nullable File mappingFile) {
        String api;
        Intrinsics.checkNotNullParameter((Object)aarFile, (String)"aarFile");
        Intrinsics.checkNotNullParameter((Object)apiFile, (String)"apiFile");
        if (!apiFile.exists()) {
            throw new AarCheckException("API check failed. Not found file " + apiFile.getCanonicalPath() + ". You can run :apiDump task to generate API declarations");
        }
        String dumpApi = FilesKt.readText$default((File)apiFile, null, (int)1, null);
        String diff = DiffUtils.INSTANCE.diff(dumpApi, api = ApiGenerator.INSTANCE.generate(aarFile, mappingFile), "dump api", "cur api");
        if (diff != null) {
            logger.error("Diff:\n" + diff);
            throw new AarCheckException("API check failed. See diff above. You can run :apiDump task to overwrite API declarations");
        }
    }

    public static /* synthetic */ void check$default(ApiChecker apiChecker, File file, File file2, File file3, int n, Object object) {
        if ((n & 4) != 0) {
            file3 = null;
        }
        apiChecker.check(file, file2, file3);
    }

    /*
     * WARNING - void declaration
     */
    public final void checkPackage(@NotNull File aarFile, @Nullable String packageName) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        Intrinsics.checkNotNullParameter((Object)aarFile, (String)"aarFile");
        if (packageName == null) {
            throw new AarCheckException("Namespace is not set.");
        }
        Iterable iterable = new JavassistParser().parseAar(aarFile);
        boolean $i$f$filterNot = false;
        void var6_5 = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Class it = (Class)element$iv$iv;
            boolean bl = false;
            String string = it.getPackageName();
            if (string != null ? StringsKt.startsWith$default((String)string, (String)packageName, (boolean)false, (int)2, null) : false) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List oddClasses = (List)destination$iv$iv;
        if (!((Collection)oddClasses).isEmpty()) {
            throw new AarCheckException("API check failed. Found classes not from package " + packageName + '.');
        }
    }

    public static /* synthetic */ void checkPackage$default(ApiChecker apiChecker, File file, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        apiChecker.checkPackage(file, string);
    }
}

