package io.appmetrica.gradle.aarcheck.utils

import java.io.File
import java.util.jar.JarEntry
import java.util.zip.ZipEntry
import java.util.zip.ZipFile

fun ZipFile.extractEntry(entryName: String): File {
    return extractEntry(getEntry(entryName))
}

fun ZipFile.extractEntry(entry: ZipEntry): File {
    val entryFile = File.createTempFile(name, entry.name.replace('/', '_'))
    entryFile.deleteOnExit()
    getInputStream(entry).use { entryInput ->
        entryFile.outputStream().use { entryFileOutput ->
            entryInput.copyTo(entryFileOutput)
        }
    }
    return entryFile
}

fun ZipFile.readFile(name: String): String {
    return getInputStream(getEntry(name)).use {
        it.bufferedReader().readText()
    }
}

fun JarEntry.isClass() = name.endsWith(".class")
