package io.appmetrica.gradle.aarcheck.utils

private const val OBFUSCATED_CLASS_NAME_MAX_LENGTH = 2

object NamesUtils {
    fun fixPackageName(name: String): String = name.replace('/', '.')

    fun unfixPackageName(name: String): String = name.replace('.', '/')

    fun getFullClassName(name: String): String = fixPackageName(name.dropLast(".class".length))

    fun isObfuscatedClassName(name: String): Boolean =
        name.substringAfterLast("$").length <= OBFUSCATED_CLASS_NAME_MAX_LENGTH
}
