package io.appmetrica.gradle.aarcheck.utils

import java.io.File

class MappingFile(file: File?) {
    private val proguardMap = ProguardMap().apply { file?.let { readFromFile(it) } }

    val hasSymbols = file != null

    fun isObfuscatedClass(className: String): Boolean {
        return getClassName(className) != className
    }

    fun getClassName(obfuscatedClassName: String): String {
        return proguardMap.getClassName(obfuscatedClassName)
    }

    fun getFieldName(clearClass: String, obfuscatedField: String): String {
        return proguardMap.getFieldName(clearClass, obfuscatedField)
    }

    fun getMethodName(clearClassName: String, obfuscatedMethodName: String, obfuscatedSignature: String): String {
        return proguardMap.getFrame(clearClassName, obfuscatedMethodName, obfuscatedSignature, "", 0).methodName
    }
}
