package io.appmetrica.gradle.aarcheck.utils

import com.github.difflib.DiffUtils
import com.github.difflib.UnifiedDiffUtils

object DiffUtils {
    private const val DIFF_CONTEXT_SIZE = 3

    fun diff(
        original: String,
        revised: String,
        originalName: String = "original",
        revisedName: String = "revised"
    ): String? {
        val originalLines = original.lines()
        val revisedLines = revised.lines()
        val diff = DiffUtils.diff(originalLines, revisedLines)
        return if (diff.deltas.isNotEmpty()) {
            val diffStr = UnifiedDiffUtils.generateUnifiedDiff(
                originalName,
                revisedName,
                originalLines,
                diff,
                DIFF_CONTEXT_SIZE
            )
            diffStr.joinToString("\n")
        } else {
            null
        }
    }
}
