package io.appmetrica.gradle.aarcheck.tasks

import org.gradle.api.Project
import org.gradle.api.Task
import org.gradle.api.tasks.TaskProvider
import kotlin.reflect.KClass

class TaskManager(private val project: Project) {
    companion object {
        const val GROUP_NAME = "aar check"
    }

    fun registerIfNotExists(name: String, createAction: TaskProvider<Task>.() -> Unit = {}): TaskProvider<Task> {
        return if (name in project.tasks.names) {
            project.tasks.named(name)
        } else {
            register<Task>(name).also(createAction)
        }
    }

    inline fun <reified T : Task> register(name: String, noinline configuration: T.() -> Unit = {}): TaskProvider<T> =
        register(name, T::class, configuration)

    fun <T : Task> register(name: String, type: KClass<T>, configuration: T.() -> Unit = {}): TaskProvider<T> =
        project.tasks.register(name, type.java) {
            group = GROUP_NAME
            configuration()
        }
}
