package io.appmetrica.gradle.aarcheck.tasks

import io.appmetrica.gradle.aarcheck.proguard.ProguardExtractor
import org.gradle.api.DefaultTask
import org.gradle.api.file.RegularFileProperty
import org.gradle.api.tasks.InputFile
import org.gradle.api.tasks.OutputFile
import org.gradle.api.tasks.TaskAction

abstract class ProguardDump : DefaultTask() {
    @get:InputFile
    abstract val aarFile: RegularFileProperty

    @get:OutputFile
    abstract val proguardDumpFile: RegularFileProperty

    @TaskAction
    fun dump() {
        logger.info("Dump proguard for ${aarFile.get()}")
        ProguardExtractor.extractToFile(
            aarFile.get().asFile,
            proguardDumpFile.get().asFile
        )
    }
}
