package io.appmetrica.gradle.aarcheck.tasks

import io.appmetrica.gradle.aarcheck.proguard.ProguardChecker
import org.gradle.api.DefaultTask
import org.gradle.api.file.RegularFileProperty
import org.gradle.api.tasks.InputFile
import org.gradle.api.tasks.TaskAction

abstract class ProguardCheck : DefaultTask() {
    @get:InputFile
    abstract val aarFile: RegularFileProperty

    @get:InputFile
    abstract val proguardDumpFile: RegularFileProperty

    @TaskAction
    fun check() {
        logger.info("Check proguard for ${aarFile.get()}")
        ProguardChecker().check(
            aarFile.get().asFile,
            proguardDumpFile.get().asFile
        )
    }
}
