package io.appmetrica.gradle.aarcheck.tasks

import org.gradle.api.DefaultTask
import org.gradle.api.file.RegularFileProperty
import org.gradle.api.tasks.InputFile
import org.gradle.api.tasks.OutputFile
import org.gradle.api.tasks.TaskAction

abstract class PomDump : DefaultTask() {
    @get:InputFile
    abstract val pomFile: RegularFileProperty

    @get:OutputFile
    abstract val pomDumpFile: RegularFileProperty

    @TaskAction
    fun dump() {
        logger.info("Dump pom file from ${pomFile.get()}")
        pomFile.get().asFile.copyTo(pomDumpFile.get().asFile, overwrite = true)
    }
}
