package io.appmetrica.gradle.aarcheck.tasks

import io.appmetrica.gradle.aarcheck.pom.PomChecker
import org.gradle.api.DefaultTask
import org.gradle.api.file.RegularFileProperty
import org.gradle.api.tasks.InputFile
import org.gradle.api.tasks.TaskAction

abstract class PomCheck : DefaultTask() {
    @get:InputFile
    abstract val pomFile: RegularFileProperty

    @get:InputFile
    abstract val pomDumpFile: RegularFileProperty

    @TaskAction
    fun check() {
        logger.info("Check pom file from ${pomFile.get()}")
        PomChecker.check(
            pomDumpFile.get().asFile,
            pomFile.get().asFile
        )
    }
}
