package io.appmetrica.gradle.aarcheck.tasks

import io.appmetrica.gradle.aarcheck.module.ModuleNormalizer
import org.gradle.api.DefaultTask
import org.gradle.api.file.RegularFileProperty
import org.gradle.api.tasks.InputFile
import org.gradle.api.tasks.OutputFile
import org.gradle.api.tasks.TaskAction

abstract class ModuleDump : DefaultTask() {
    @get:InputFile
    abstract val moduleFile: RegularFileProperty

    @get:OutputFile
    abstract val moduleDumpFile: RegularFileProperty

    @TaskAction
    fun dump() {
        logger.info("Dump module file from ${moduleFile.get()}")
        moduleDumpFile.get().asFile.writeText(
            ModuleNormalizer.normalize(moduleFile.get().asFile.readText())
        )
    }
}
