package io.appmetrica.gradle.aarcheck.tasks

import io.appmetrica.gradle.aarcheck.module.ModuleChecker
import org.gradle.api.DefaultTask
import org.gradle.api.file.RegularFileProperty
import org.gradle.api.tasks.InputFile
import org.gradle.api.tasks.TaskAction

abstract class ModuleCheck : DefaultTask() {
    @get:InputFile
    abstract val moduleFile: RegularFileProperty

    @get:InputFile
    abstract val moduleDumpFile: RegularFileProperty

    @TaskAction
    fun check() {
        logger.info("Check module file from ${moduleFile.get()}")
        ModuleChecker.check(
            moduleDumpFile.get().asFile,
            moduleFile.get().asFile
        )
    }
}
